<?php

/**
 * i-doit
 *
 * Popup class for attribute-settings feature.
 *
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_attribute_setting_delete extends isys_component_popup
{
    /**
     * @param isys_component_template $template
     * @param array                   $parameters
     *
     * @return string
     */
    public function handle_smarty_include(isys_component_template $template, $parameters)
    {
        return '<button type="button" class="btn btn-secondary" data-action="delete" data-tooltip="1" onclick="' . $this->process_overlay('', 480, 160, ['ids' => $parameters['ids']]) . '" title="' . $this->language->get('LC__UNIVERSAL__DELETE') . '">' .
            '<img src="' . rtrim(isys_application::instance()->www_path, '/') . '/images/axialis/industry-manufacturing/waste-bin.svg" alt="" />' .
            '</button>';
    }

    /**
     * @param isys_module_request $moduleRequest
     *
     * @return void
     * @throws \idoit\Exception\JsonException
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));
        $ids = isys_format_json::decode($parameters['ids']);

        // Display the dialog template and return it.
        $this->template
            ->assign('ids', $parameters['ids'])
            ->assign('plural', count($ids) > 1)
            ->display(isys_module_pro::getPath() . 'templates/SettingPage/AttributeSettings/popup/delete.tpl');
        die;
    }
}
