<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type LoginLogout
 * This is the primary authentication interface used to login and logout.

A login call requires a username and a password for the authentication. On successful authentication, the call returns an
 - access token
 - renewal token

The access token must be added to the HTTPS request headers to ensure a user has access to the appropriate resources.
An access token has usually a limited lifetime. This is done for various security reasons: for one, limiting the lifetime
of the access token limits the amount of time an attacker can use a stolen token. In addition, the information contained
in or referenced by the access token could become stale.
When access tokens expire or become invalid but the application still needs to access a protected resource, the application
faces the problem of getting a new access token without forcing the user to once again grant permission. To solve this problem,
a refresh token is introduced. A refresh token allows an application to obtain a new access token without prompting the user.

The access token must be added into the HTTPS header as parameter "Authorization". The value must be the String "Bearer"
followed by a space and the access token. When the access token has expired, then the server returns an SC_UNAUTHORIZED (401)
In this case, you might use the refresh token to obtain a new access and refresh token using the refreshAccessToken call.
The GraphQL also returns an SC_UNAUTHORIZED (401) when the renewal token has expired. */
final class LoginLogoutType implements AutoGenerationInterface
{
    /**
     * Checks the access token and returns false when it is invalid.
     */
    public bool $checkAccessToken;
    /**
     * Login to obtain an access token for API calls
     */
    public ?LoginResultType $login = null;
    /**
     * Login to obtain an access token for particular audience
- Web UI requires token with 'UI' audience to support dead session detection via WebSocket keep alive subscriptions
- custom scripts should use default option with 'API'
- custom scripts which acquired password from JDisc Discovery in en encrypted form should use 'SECURED'
     */
    public ?LoginResultType $loginEx = null;
    /**
     * Logout the current session. Always returns true as a return value is required by GraphQL
     */
    public bool $logout;
    /**
     * Callback to inform Web UI backend, that Web frontend client is still active
     */
    public ?PongRequestType $pongSessionAlive = null;
    /**
     * Use the refresh token to obtain a new access and refresh token when the previous access token expired
     */
    public ?LoginResultType $refreshAccessToken = null;
}