<?php

/**
 * i-doit
 *
 * Popup class for attribute-settings feature.
 *
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_attribute_setting_add extends isys_component_popup
{
    /**
     * @param isys_component_template $template
     * @param array                   $parameters
     *
     * @return string
     */
    public function handle_smarty_include(isys_component_template &$template, $parameters)
    {
        // Will be added in the navbar.
        return '';
    }

    /**
     * @param isys_module_request $moduleRequest
     *
     * @return void
     * @throws \idoit\Exception\JsonException
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));
        $routeGenerator = isys_application::instance()->container->get('route_generator');

        // Display the dialog template and return it.
        $this->template
            ->assign('wwwPath', isys_module_pro::getWwwPath())
            ->assign('loadAttributesUrl', $routeGenerator->generate('pro.attribute-settings.load-attributes'))
            ->assign('createAttributeSettingUrl', $routeGenerator->generate('pro.attribute-settings.create-attribute-setting'))
            ->display(isys_module_pro::getPath() . 'templates/SettingPage/AttributeSettings/popup/add.tpl');
        die;
    }
}
