<?php

use idoit\Module\Pro\Model\CategoryFolders\Config;

/**
 * i-doit
 *
 * Popup class for category folders feature.
 *
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class isys_popup_category_folders_reset extends isys_component_popup
{
    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param isys_component_template $template
     * @param array                   $parameters
     *
     * @return string
     */
    public function handle_smarty_include(isys_component_template $template, $parameters)
    {
        $l_button_options = [
            'id'                => $parameters['name'],
            'icon'              => isys_application::instance()->www_path . 'images/axialis/basic/symbol-cancel.svg',
            'p_bInfoIconSpacer' => 0,
            'p_onClick'         => $this->getModalJs('', 500, 150, [], 500, 150, 'configuration'),
            'type'              => 'button',
            'p_strValue'        => $this->language->get('LC__CATEGORY_FOLDERS__RESET'),
            'p_strClass'        => 'ml-auto',
            'p_bDisabled'       => true
        ];

        return (new isys_smarty_plugin_f_button())->navigation_edit($this->template, $l_button_options);
    }

    /**
     * Method for handling the module request.
     *
     * @param isys_module_request $p_modreq
     *
     * @throws \idoit\Exception\JsonException
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        // Unpack popup request.
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));

        $configurationId = (int)$parameters['configId'];
        $objectTypeId = (int)$parameters['objectTypeId'];

        $configuration = Config::instance($this->database)->getById($configurationId);

        if ($configuration === null || $configuration['objectTypeId'] != $objectTypeId) {
            throw new Exception('');
        }

        $objectTypeTitle = isys_application::instance()->container->get('cmdb_dao')
            ->get_objtype_name_by_id_as_string($objectTypeId);

        // Display the dialog template and return it.
        $this->template->assign('configurationId', $configurationId)
            ->assign('confirmationMessage', $this->language->get('LC__CATEGORY_FOLDERS__RESET_CONFIRMATION', $this->language->get($objectTypeTitle)))
            ->assign('resetUrl', isys_application::instance()->container->get('route_generator')->generate('pro.category-folders.reset'))
            ->display(isys_module_pro::getPath() . 'templates/SettingPage/CategoryFolders/popup/reset-folder.tpl');

        die;
    }
}
