<?php

global $g_comp_database, $g_comp_database_system;

// Set migrationId
$migrationIdentifier = 'migrate_port_groups';

// Check whether migration was executed before
if ($this->is_migration_done($migrationIdentifier)) {
    $g_migration_log[] = '<span class="bold">Migration of switch ports already done.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Migrate switch ports...</span>';

    $dao = new \isys_cmdb_dao($g_comp_database);

    $query = "SELECT * FROM isys_virtual_device_host
        INNER JOIN isys_catg_virtual_device_list ON isys_catg_virtual_device_list__id = isys_virtual_device_host__isys_catg_virtual_device_list__id
        WHERE isys_virtual_device_host__switch_port_group != '';";

    $result = $dao->retrieve($query);
    $manualUpdate = $update = [];
    while ($row = $result->get_row()) {
        $switchPort = $dao->convert_sql_text($row['isys_virtual_device_host__switch_port_group']);
        $virtualHostId = $dao->convert_sql_id($row['isys_virtual_device_host__id']);
        $objectId = $dao->convert_sql_id($row['isys_catg_virtual_device_list__isys_obj__id']);

        $vmQuery = "SELECT * FROM isys_catg_virtual_machine_list
            INNER JOIN isys_connection ON isys_connection__id = isys_catg_virtual_machine_list__isys_connection__id
            INNER JOIN isys_obj ON isys_obj__id = isys_connection__isys_obj__id
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_catg_virtual_machine_list__isys_obj__id = {$objectId}";

        $vmData = $dao->retrieve($vmQuery)->get_row();

        if (empty($vmData)) {
            continue;
        }
        $vmObjectId = $vmData['isys_connection__isys_obj__id'];

        if ($vmData['isys_obj_type__const'] === 'C__OBJTYPE__CLUSTER') {
            $vmObjectId = $vmData['isys_catg_virtual_machine_list__primary'];
        }

        if (empty($vmObjectId)) {
            continue;
        }

        $vmObjectId = $dao->convert_sql_id($vmObjectId);

        $virtualSwitchQuery = "SELECT * FROM isys_catg_virtual_switch_list
                LEFT JOIN isys_virtual_port_group ON isys_virtual_port_group__isys_catg_virtual_switch_list__id = isys_catg_virtual_switch_list__id
                WHERE isys_catg_virtual_switch_list__isys_obj__id = {$vmObjectId}
                AND isys_virtual_port_group__title = {$switchPort}";
        $resultSwitch = $dao->retrieve($virtualSwitchQuery);

        if ($resultSwitch->count() > 1) {
            // can not determine which one to use collect it for the user
            $g_migration_log[] = "<span class='indent'>Could not determine which port group to use for {$row['isys_obj__title']} #{$objectId} with Port Group Name {$switchPort}. Please edit and save the entry manually in category Virtual devices.</span>";
            continue;
        }

        $virtualPortId = $dao->convert_sql_id($resultSwitch->get_row_value('isys_virtual_port_group__id'));
        $update[] = "UPDATE isys_virtual_device_host SET isys_virtual_device_host__isys_virtual_port_group__id = {$virtualPortId}
                WHERE isys_virtual_device_host__id = {$virtualHostId};";
    }

    if (!empty($update)) {
        foreach ($update as $updateQuery) {
            $dao->update($updateQuery);
        }
        $dao->apply_update();
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    $this->migration_done($migrationIdentifier);
}
