<?php

global $g_comp_database, $g_comp_database_system;

// Set migrationId
$migrationIdentifier = 'migrate_self_created_report_permission';

// Check whether migration was executed before
if ($this->is_migration_done($migrationIdentifier)) {
    $g_migration_log[] = '<span class="bold">Migration permission "self created reports" already done.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Migrate permission "self created reports" ...</span>';
    $dao = new \isys_auth_dao_report($g_comp_database);
    $result = $dao->retrieve("SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const IN ('C__OBJ__PERSON_ADMIN', 'C__OBJ__PERSON_GROUP_ADMIN');");

    if ($result->count() > 0) {
        $rights = [
            isys_auth::VIEW,
            isys_auth::EDIT,
            isys_auth::DELETE,
            isys_auth::EXECUTE,
            isys_auth::SUPERVISOR
        ];

        $pathData = [
            'self_created_reports' => [
                null => $rights
            ]
        ];

        while($data = $result->get_row()) {
            // Add right for the report
            isys_auth_dao::instance($g_comp_database)
                ->create_paths($data['isys_obj__id'], defined_or_default('C__MODULE__REPORT'), $pathData);
        }
        $g_migration_log[] = '<span class="bold">Migration finished!</span>';
    } else {
        $g_migration_log[] = '<span class="indent">Default Person and Person group do not exists. Migration skipped.</span>';
    }
    $this->migration_done($migrationIdentifier);
}
