<?php

// @see ID-10833 Notify the user about duplicate person group entries.

global $g_comp_database;

$g_migration_log[] = '<span class="bold">Check for duplicated entries in "Person groups" category...</span>';

$dao = new \isys_cmdb_dao_category_s_organization_master($g_comp_database);

$query = 'SELECT
    isys_obj__id as id,
    isys_obj__title as title,
    count(isys_cats_person_group_list__isys_obj__id) as cnt
    FROM isys_cats_person_group_list
    LEFT JOIN isys_obj ON isys_obj__id = isys_cats_person_group_list__isys_obj__id
    GROUP BY isys_cats_person_group_list__isys_obj__id
    HAVING cnt > 1;';

$result = $dao->retrieve($query);

if (count($result) === 0) {
    $g_migration_log[] = '<span>No duplicated person groups - all good!</span>';
} else {
    while ($row = $result->get_row()) {
        $g_migration_log[] = '<span>Found a duplicate entry in object #' . $row['id'] . ' "' . $row['title'] . '"</span>';
    }
}
