<?php
namespace idoit\Module\JDisc\Graphql\Query;

use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\JDisc\Graphql\AbstractGraphql;
use idoit\Module\JDisc\Graphql\ResponseInterface;
use idoit\Module\JDisc\Graphql\Schema\Model\DiscoveryStatusAreaEnum;

class GetDiscoveryLog extends AbstractGraphql implements ResponseInterface
{
    public function getParameters(): array
    {
        return [];
    }

    public function getSelections(): array
    {
        return [];
    }

    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return [
            'status' => $data['status']['discovery']['status']['discoveryProcessStatus'],
            'log' => $data['status']['discovery']['status']['deviceQueueStatus']['lastAction'],
        ];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query('status'))
            ->setSelectionSet([
                (new Query('discovery'))
                    ->setSelectionSet([
                        (new Query('status'))
                            ->setArguments(['statusArea' => new DiscoveryStatusAreaEnum('All')])
                            ->setSelectionSet([
                                'discoveryProcessStatus',
                                (new Query('deviceQueueStatus'))
                                    ->setSelectionSet([
                                        'lastAction',
                                        (new Query('devices'))
                                            ->setSelectionSet(['target', 'lastLog'])
                                    ])
                            ])
                    ])
            ]);
    }
}