<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Component\FeatureManager\FeatureManager;
use idoit\Psr4AutoloaderClass;

Autoloader::appendClassmap(require_once __DIR__ . '/classmap.php');

Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\Ldap', __DIR__ . '/src/');

isys_application::instance()->container->get('signals')
    ->connect('mod.settings.extendTree.interfaces', ['isys_module_ldap', 'extendInterfacesTree']);

if (FeatureManager::isFeatureActive('ldap-settings')) {
    isys_settings::extend([
        'Logging' => [
            'ldap.debug' => [
                'title'       => 'LDAP Debug',
                'type'        => 'select',
                'description' => 'ldap_debug in log/',
                'options'     => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ]
        ]
    ]);

    isys_tenantsettings::extend([
        'LDAP' => [
            'ldap.default-group'           => [
                'title'          => 'LC__SYSTEM_SETTINGS__DEFAULT_LDAP_GROUP',
                'type'           => 'text',
                'validationRule' => 'comma-separated-ids',
                'description'    => 'LC__SYSTEM_SETTINGS__LDAP_GROUP_DESCRIPTION',
                'placeholder'    => ''
            ],
            'ldap.config'                  => [
                'title'       => 'LDAP Config:',
                'type'        => 'textarea',
                'default'     => '',
                'description' => 'JSON String'
            ],
            'ldap.person.salutation.man'   => [
                'title'       => 'LC__LDAP__MAPPING__SALUTATION__MAN',
                'type'        => 'text',
                'default'     => 'Herr, Mr., Mr',
                'description' => 'LC__LDAP__MAPPING__SALUTATION__MAN_DESC'
            ],
            'ldap.person.salutation.woman' => [
                'title'       => 'LC__LDAP__MAPPING__SALUTATION__WOMAN',
                'type'        => 'text',
                'default'     => 'Frau, Mrs., Mrs, Ms., Ms, Miss',
                'description' => 'LC__LDAP__MAPPING__SALUTATION__WOMAN_DESC'
            ],
        ]
    ]);
}
