<?php

namespace idoit\Component;

use isys_application;
use Monolog\Formatter\LineFormatter;

/**
 * i-doit Logger - extends the brilliant Monolog class with a few own methods (mostly used for the GUI).
 *
 * @package    i-doit
 * @subpackage Component
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class Logger extends \Monolog\Logger
{
    /**
     * @param string $name
     * @param string $logPath
     *
     * @return Logger
     */
    public static function factory($name, $logPath, int $level = Logger::WARNING)
    {
        $logHandler = new CountingRotatingFileHandler($logPath, 0, $level);
        $logHandler->setFilenameFormat('{filename}_{date}', CountingRotatingFileHandler::FILE_PER_DAY);

        // Keep the defaults, but allow line breaks and ignore empty 'context' and 'extra'.
        $logHandler->setFormatter(new LineFormatter(null, 'Y-m-d H:i:s', true, true));

        $log = new self($name);
        $log->pushHandler($logHandler);

        return $log;
    }

    /**
     * Method for retrieving a fitting icon for every log level.
     *
     * @param integer $level
     *
     * @static
     * @return string|array
     */
    public static function getLevelIcons($level = null)
    {
        global $g_dirs;

        $icons = [
            self::DEBUG     => $g_dirs["images"] . 'axialis/development/bug.svg',
            self::INFO      => $g_dirs["images"] . 'axialis/basic/button-info.svg',
            self::NOTICE    => $g_dirs["images"] . 'axialis/basic/comment-empty.svg',
            self::WARNING   => $g_dirs["images"] . 'axialis/basic/warning.svg',
            self::ERROR     => $g_dirs["images"] . 'axialis/basic/button-info-yellow.svg',
            self::CRITICAL  => $g_dirs["images"] . 'axialis/basic/button-info-red.svg',
            self::ALERT     => $g_dirs["images"] . 'axialis/basic/button-remove.svg',
            self::EMERGENCY => $g_dirs["images"] . 'axialis/basic/symbol-forbidden.svg'
        ];

        if ($level !== null) {
            return $icons[$level];
        }

        return $icons;
    }

    /**
     * Method for retrieving a fitting text-color (via CSS class) for every log level.
     *
     * @param integer $level
     *
     * @static
     * @return string|array
     * @author Leonard Fischer <lfischer@i-doit.com>
     */
    public static function getLevelColors($level = null)
    {
        $colors = [
            self::DEBUG     => 'green',
            self::INFO      => 'blue',
            self::NOTICE    => '',
            self::WARNING   => 'yellow',
            self::ERROR     => 'red',
            self::CRITICAL  => 'red',
            self::ALERT     => 'red',
            self::EMERGENCY => 'red'
        ];

        if ($level !== null) {
            return $colors[$level];
        }

        return $colors;
    }

    /**
     * Gets log level as string.
     *
     * @param int $level
     *
     * @static
     * @return string|array
     * @author Leonard Fischer <lfischer@i-doit.com>
     */
    public static function getLevelNames($level = null)
    {
        $language = isys_application::instance()->container->get('language');

        $names = [
            self::DEBUG     => $language->get('LC_UNIVERSAL__LOG_LEVEL__DEBUG'),
            self::INFO      => $language->get('LC_UNIVERSAL__LOG_LEVEL__INFO'),
            self::NOTICE    => $language->get('LC_UNIVERSAL__LOG_LEVEL__NOTICE'),
            self::WARNING   => $language->get('LC_UNIVERSAL__LOG_LEVEL__WARNING'),
            self::ERROR     => $language->get('LC_UNIVERSAL__LOG_LEVEL__ERROR'),
            self::CRITICAL  => $language->get('LC_UNIVERSAL__LOG_LEVEL__CRITICAL'),
            self::ALERT     => $language->get('LC_UNIVERSAL__LOG_LEVEL__FATAL_ERROR'),
            self::EMERGENCY => $language->get('LC_UNIVERSAL__LOG_LEVEL__FATAL_ERROR'),
        ];

        if ($level !== null) {
            return $names[$level];
        }

        return $names;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addDebug($message, array $context = []): bool
    {
        parent::debug($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addInfo($message, array $context = []): bool
    {
        parent::info($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addNotice($message, array $context = []): bool
    {
        parent::notice($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addWarning($message, array $context = []): bool
    {
        parent::warning($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function warn($message, array $context = []): bool
    {
        parent::warning($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addError($message, array $context = []): bool
    {
        parent::error($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function err($message, array $context = []): bool
    {
        parent::error($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addCritical($message, array $context = []): bool
    {
        parent::critical($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function crit($message, array $context = []): bool
    {
        parent::critical($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addAlert($message, array $context = []): bool
    {
        parent::alert($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function addEmergency($message, array $context = []): bool
    {
        parent::emergency($message, $context);

        return true;
    }

    /**
     * @param string $message
     * @param array  $context
     *
     * @return bool
     * @deprecated Implemented due to compatibility, see ID-7538. Will be removed in i-doit 1.18.
     */
    public function emerg($message, array $context = []): bool
    {
        parent::emergency($message, $context);

        return true;
    }

    /**
     * Method for compability with isys_log
     *
     * @param bool $print
     * @param bool $standalone
     *
     * @return bool
     *
     * @deprecated needs to be removed after everything has been refactored to Monolog
     */
    public function flush_verbosity($print = true, $standalone = true)
    {
        return true;
    }

    /**
     * Method for compability with isys_log
     *
     * @param $mode
     *
     * @return bool
     *
     * @deprecated needs to be removed after everything has been refactored to Monolog
     */
    public function set_destruct_flush($mode)
    {
        return true;
    }
}
