<?php

use idoit\Module\Qrcode\Controller\ImageController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('qrcode.image.object', '/qrcode/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ImageController::class, 'getObjectQrCode']);

    $routes->add('barcode.image.object', '/barcode/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ImageController::class, 'getObjectBarcode']);
};
