<?php

/**
 * QR-Code AJAX handler.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.3.0
 */
class isys_ajax_handler_qrcode extends isys_ajax_handler
{
    /**
     * Init method, which gets called from the framework.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function init()
    {
        // We set the header information because we don't accept anything than JSON.
        header('Content-Type: application/json');

        $l_return = [
            'success' => true,
            'message' => null,
            'data'    => null
        ];

        try {
            $objectId = (int)$_POST[C__CMDB__GET__OBJECT];
            $routeGenerator = isys_application::instance()->container->get('route_generator');

            $l_return['data'] = (new \idoit\Module\Qrcode\Component\QrCode())->getData($objectId);
            $l_return['data']['qrcodeUrl'] = $routeGenerator->generate('qrcode.image.object', ['objectId' => $objectId]);
            $l_return['data']['barcodeUrl'] = $routeGenerator->generate('barcode.image.object', ['objectId' => $objectId]);
        } catch (Exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        echo isys_format_json::encode($l_return);

        $this->_die();
    }

    /**
     * This method defines, if the hypergate needs to be included for this request.
     *
     * @static
     * @return  boolean
     */
    public static function needs_hypergate()
    {
        return true;
    }
}
