<?php

use idoit\Module\Qrcode\Component\QrCode;

/**
 * i-doit Report Manager View
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @copyright   Copyright 2013 - synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.0
 */
class isys_qrcode_reportview_qr_codes extends isys_report_view
{
    /**
     * @return string
     */
    public static function name()
    {
        return 'LC__REPORT__VIEW__QR_CODES';
    }

    /**
     * @return string
     */
    public static function description()
    {
        return 'LC__REPORT__VIEW__QR_CODES_DESCRIPTION';
    }

    /**
     * @return string
     */
    public function template()
    {
        return __DIR__ . '/view_qr_codes.tpl';
    }

    /**
     * @return string
     */
    public static function viewtype()
    {
        return 'LC__REPORT__VIEW__QR_CODES';
    }

    /**
     * Start-method - Implement the logic for displaying your data here.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @return  void
     */
    public function start()
    {
        if (!defined('C__MODULE__SYSTEM') || !defined('C__MODULE__QRCODE')) {
            return;
        }
        global $g_dirs;

        $l_rules = [
            'C__QR_CODE_DEFAULT_TEXT_ALIGNMENT' => [
                'p_arData'        => [
                    'left'    => $this->language->get('LC__QR_CODE_DEFAULT_TEXT_ALIGNMENT_LEFT'),
                    'center'  => $this->language->get('LC__QR_CODE_DEFAULT_TEXT_ALIGNMENT_CENTER'),
                    'right'   => $this->language->get('LC__QR_CODE_DEFAULT_TEXT_ALIGNMENT_RIGHT'),
                    'justify' => $this->language->get('LC__QR_CODE_DEFAULT_TEXT_ALIGNMENT_JUSTIFY')
                ],
                'p_strSelectedID' => 'center',
                'p_strClass'      => 'input-mini'
            ]
        ];

        $l_layouts = file_get_contents(__DIR__ . '/view_qr_code_layouts.html');
        $l_layouts = str_replace([
            '%qrcode_url%',
            '%description%',
            '%logo_url%'
        ], [
            $g_dirs['images'] . 'axialis/transportation/label-qrcode.svg',
            $this->language->get('LC__REPORT__VIEW__QR_CODES__LAYOUT_DESCRIPTION'),
            $g_dirs['images'] . 'favicon.png'
        ], $l_layouts);

        $l_configuration_url = isys_helper_link::create_url([
            C__GET__MODULE_ID     => C__MODULE__SYSTEM,
            C__GET__MODULE_SUB_ID => C__MODULE__QRCODE,
            C__GET__TREE_NODE     => C__MODULE__QRCODE . '0'
        ]);

        // Assign the ajax URL to the template.
        $this->template
            ->activate_editmode()
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules)
            ->assign('configuration_url', $l_configuration_url)
            ->assign('ajax_url', isys_glob_add_to_query('ajax', 1))
            ->assign('layouts', explode('---', $l_layouts));
    }

    /**
     * Method for ajax-requests.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function ajax_request()
    {
        global $g_dirs;

        // This will be used for the printable popup.
        if ($_GET['printview'] == '1') {
            $l_layouts = explode('---', file_get_contents(__DIR__ . '/view_qr_code_layouts.html'));

            $l_layout = str_replace([
                '%qrcode_url%',
                '%description%',
                '%logo_url%'
            ], [
                $g_dirs['images'] . 'axialis/transportation/label-qrcode.svg',
                $this->language->get('LC__REPORT__VIEW__QR_CODES__LAYOUT_DESCRIPTION'),
                $g_dirs['images'] . 'favicon.png'
            ], $l_layouts[$_GET['layout']]);

            $this->template
                ->assign('ajax_url', isys_helper_link::remove_params_from_url('?' . $_SERVER['QUERY_STRING'], 'printview'))
                ->assign('qr_code_size', $_GET['size'])
                ->assign('columns', $_GET['cols'])
                ->assign('obj_ids', $_GET['objects'])
                ->assign('text_alignment', $_GET['text_alignment'])
                ->assign('layout', $l_layout)
                ->display(__DIR__ . '/view_qr_codes_popup.tpl');
            die();
        }

        $l_return = ['success' => true];

        try {
            if (isset($_POST['obj_ids'])) {
                $l_object_ids = isys_format_json::decode($_POST['obj_ids'], true);
            } else {
                $l_object_ids = [];
            }

            if (is_array($l_object_ids)) {
                foreach ($l_object_ids as $l_object_id) {
                    $qrCodeData = (new QrCode())->getData((int)$l_object_id);

                    if (isys_tenantsettings::get('barcode.type', 'qr') === 'qr') {
                        $l_url = isys_application::instance()->container->get('route_generator')->generate('qrcode.image.object', ['objectId' => $l_object_id]);
                    } else {
                        $l_url = isys_application::instance()->container->get('route_generator')->generate('barcode.image.object', ['objectId' => $l_object_id]);
                    }

                    $l_return['data'][] = [
                        'logo'        => $qrCodeData['logo'],
                        'success'     => true,
                        'url'         => $l_url,
                        'description' => $qrCodeData['description']
                    ];
                }
            }
        } catch (Exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        header('Content-Type: application/json');

        echo isys_format_json::encode($l_return);

        die;
    }
}
