<?php

namespace idoit\Module\Report\SqlQuery\Condition\PropertyType;

use idoit\Component\Property\Property;
use idoit\Module\Report\SqlQuery\Condition\ConditionType;
use idoit\Module\Report\SqlQuery\Condition\ConditionTypeInterface;

/**
 * @package     i-doit
 * @subpackage  Core
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class ObjectBrowser extends ConditionType implements ConditionTypeInterface
{
    /**
     * @return bool
     */
    public function isApplicable()
    {
        $property = $this->getProperty();
        return ($property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__OBJECT_BROWSER);
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function format()
    {
        $conditionData = $this->getConditionData();
        $conditionField = $this->getConditionField();
        $conditionComparison = $this->getConditionComparison();
        $conditionValue = $this->getConditionValue();
        $dao = \isys_application::instance()->container->get('cmdb_dao');

        $condition = $conditionField . ' ' . $conditionComparison . ' ' . $dao->convert_sql_text($conditionValue) . ' ';

        if (is_array($conditionValue)) {
            if ($conditionComparison === '=') {
                $conditionComparison = ' IN ';
            } else {
                $conditionComparison = ' NOT IN ';
            }

            $condition = sprintf("$conditionField {$conditionComparison} (%s)", implode(',', array_map([$dao, 'convert_sql_text'], $conditionValue)));
        }

        if (strpos($conditionComparison, 'PLACEHOLDER.') !== false) {
            return '(' . $condition . ')';
        }

        if ($conditionComparison === 'IS NULL' || $conditionComparison === 'IS NOT NULL') {
            $condition = '';
        }

        if (empty($condition) || (int)$conditionValue === 0 || $conditionValue == '-1') {
            if ($conditionComparison === '=') {
                $conditionComparison = 'IS NULL';
                $condition .= ' OR ';
            }
            if ($conditionComparison === '!=') {
                $conditionComparison = 'IS NOT NULL';
                $condition .= ' AND ';
            }

            $condition .= $conditionField . ' ' . $conditionComparison;
        }

        return '(' . $condition . ')';
    }
}
