<?php

use idoit\Component\Property\Property;

/**
 * i-doit
 *
 * DAO: specific category for applications with assigned objects.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_s_database_installation extends isys_cmdb_dao_category_s_application_assigned_obj
{
    /**
     * Category's name. Will be used for the identifier, constant, main table, and many more.
     *
     * @var  string
     */
    protected $m_category = 'database_installation';

    /**
     * Return Category Data.
     *
     * @param   integer $p_cats_list_id
     * @param   integer $p_obj_id
     * @param   string  $p_condition
     * @param   array   $p_filter
     * @param   integer $p_status
     *
     * @return  isys_component_dao_result
     */
    public function get_data($p_cats_list_id = null, $p_obj_id = null, $p_condition = "", $p_filter = null, $p_status = C__RECORD_STATUS__NORMAL)
    {
        $l_dao = new isys_cmdb_dao_category_g_application($this->m_db);

        if ($p_obj_id > 0) {
            $l_condition = ' AND isys_connection__isys_obj__id = ' . $l_dao->convert_sql_id($p_obj_id);
        } else {
            $l_condition = '';
        }

        return $l_dao->get_data($p_cats_list_id, null, $l_condition, $p_filter, $p_status);
    }

    /**
     * Get assigned databases by application assignment id
     *
     * @param int $applicationId
     *
     * @return array
     * @throws isys_exception_database
     */
    public function getAssignedDatabases($applicationId)
    {
        $data = [];

        $query = 'SELECT isys_catg_database_list__id as id, isys_obj__id as objectId, isys_obj__isys_obj_type__id AS objectTypeId, isys_catg_database_list__title as title
          FROM isys_catg_database_list
          INNER JOIN isys_obj ON isys_obj__id = isys_catg_database_list__isys_obj__id
          WHERE isys_catg_database_list__isys_catg_application_list__id = ' . $this->convert_sql_id($applicationId);
        $result = $this->retrieve($query);
        if ($result instanceof isys_component_dao_result && count($result)) {
            while ($row = $result->get_row()) {
                $data[$row['id']] = [
                    C__CMDB__GET__OBJECT => $row['objectId'],
                    C__CMDB__GET__OBJECTTYPE => $row['objectTypeId'],
                    'title' => $row['title']
                ];
            }
        }
        return $data;
    }

    /**
     * Method for returning the properties.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function properties()
    {
        /** @var Property[] $properties */
        $properties = parent::properties();

        $properties['description']->getUi()
            ->setId('C__CMDB__CAT__COMMENTARY_' . C__CMDB__CATEGORY__TYPE_GLOBAL . defined_or_default('C__CATS__DATABASE_INSTALLATION', 'C__CATS__DATABASE_INSTALLATION'));

        return $properties;
    }
}
