<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CyberarkServerDataInput
 * This object contains information about the cyberark secret server. * @property null|string $appId = null The application id
 * @property null|CyberarkAuthenticationTypeEnum $authType = null The authentication type
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|string $name = null The server's descriptive name as provided by the user.
 * @property null|string $objectName = null The object name
 * @property null|int $port = null The port that the server is listening on.
 * @property null|string $safeName = null The safe name
 * @property null|string $serverAddress = null The server's address (IP address or hostname).
 * @property null|PasswordManagementStatusInputInputType $status = null The server status
 * @property null|string $username = null The username used to authenticate against the Cyberark server..
 * @property null|string $label = null The server label
 */
final class CyberarkServerDataInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'authType') {
            return new CyberarkAuthenticationTypeEnum($value);
        }

        if ($name === 'status') {
            return new PasswordManagementStatusInputInputType($value);
        }

        return $value;
    }
}