<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DeviceRelation
 * A relation between two devices. The kind of relation is defined by the relation type. */
final class DeviceRelationType implements AutoGenerationInterface
{
    /**
     * A display name for the relation (if any)
     */
    public ?string $displayName = null;
    /**
     * The state for a relation between two devices. This state is used
for instance for virtualation relations between the physical host and the VM
in order to indicate the virtual machine state
     */
    public ?ConnectorStateEnum $state = null;
    /**
     * The direction of the relation. Forward means source initiated, Backward means destination initiated.
     */
    public ?ConnectionDirectionEnum $direction = null;
    /**
     * The connector internal id. The internal id depends on the relation type.
For VMware virtual machine relations, the type can be the VM UUID (unique id).
     */
    public ?string $internalId = null;
    /**
     * The relation type for relations between two devices
     */
    public ?ConnectorTypeEnum $relationType = null;
    /**
     * The source device for the relation
     */
    public ?DeviceType $sourceDevice = null;
    /**
     * The target device for the relation
     */
    public ?DeviceType $targetDevice = null;
}