<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type InstalledEndpointSecuritySoftware
 * An endpoint security software installed on an operating system. */
final class InstalledEndpointSecuritySoftwareType implements AutoGenerationInterface
{
    /**
     * A flag whether the endpoint security's anti-spyware is enabled
     */
    public ?bool $antiSpywareEnabled = null;
    /**
     * The timestamp when the anti-spyware version was last updated
     */
    public $antiSpywareLastUpdated = null;
    /**
     * The anti-spyware version
     */
    public ?string $antiSpywareVersion = null;
    /**
     * A flag whether the endpoint security's antivirus is enabled
     */
    public ?bool $antivirusEnabled = null;
    /**
     * The timestamp when the antivirus signature was last updated
     */
    public $antivirusLastUpdated = null;
    /**
     * The antivirus signature version
     */
    public ?string $antivirusSignatureVersion = null;
    /**
     * The associated endpoint security application
     */
    public ?ApplicationType $application = null;
    /**
     * A flag whether the endpoint security is enabled
     */
    public ?bool $enabled = null;
    /**
     * The endpoint security application installation path
     */
    public ?string $installationPath = null;
    /**
     * A flag whether the endpoint NIS is enabled
     */
    public ?bool $nisEnabled = null;
    /**
     * The antivirus NIS engine version
     */
    public ?string $nisEngineVersion = null;
    /**
     * The timestamp when the NIS signature was last updated
     */
    public $nisSignatureLastUpdated = null;
    /**
     * The antivirus NIS signature version
     */
    public ?string $nisSignatureVersion = null;
    /**
     * The operating system the endpoint security software is installed on
     */
    public ?OperatingSystemType $operatingSystem = null;
    /**
     * A flag whether the endpoint security's realtime protection is enabled
     */
    public ?bool $realtimeProtectionEnabled = null;
    /**
     * The endpoint security unique id
     */
    public ?string $uniqueId = null;
    /**
     * A flag whether the endpoint security is up-to-date
     */
    public ?bool $upToDate = null;
}