<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type KubernetesDaemonSetInput
 * A Kubernetes daemonset. * @property null|ClusterInputInputType $cluster = null The cluster that this daemonset is assigned to.
 * @property null|string $name = null The kubernetes daemonset name.
 * @property null|KubernetesNamespaceInputInputType $namespace = null The namespace that this daemonset is assigned to.
 * @property null|iterable|DeviceInputInputType[] $pods = null The pods belonging to this daemonset
 * @property null|iterable|DeviceInputInputType[] $services = null The pods belonging to this daemonset
 * @property null|string $uniqueId = null A kubernetes daemonset's unique id.
 */
final class KubernetesDaemonSetInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'cluster') {
            return new ClusterInputInputType($value);
        }

        if ($name === 'namespace') {
            return new KubernetesNamespaceInputInputType($value);
        }

        if ($name === 'pods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'services') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        return $value;
    }
}