<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ReportConfig
 * Report configuration * @property null|BuiltInReportEnum $builtInReport = null The built-in report
 * @property mixed $customReportId = null The report id
 * @property null|bool $expandMultilineRows = null When true, a row which contains multiline cells will be expanded to separate rows
 * @property null|iterable|FieldFilterInputInputType[] $filters = null The list of filters
 * @property null|iterable|FieldDescriptionInputInputType[] $orderedVisibleColumns = null The user specific column order and visibility
 * @property null|PagingInputInputType $paging = null The paging configuration. When null, then it returns all data
 * @property null|string $reportCacheId = null The report cache id. Reports can be cached. When using the cacheId, then the server gets the cached report. Otherwise, it gets the report from the database.
 * @property null|SearchConfigurationInputInputType $searchConfig = null The paging configuration. When null, then it returns all data
 * @property null|iterable|SortEntryInputInputType[] $sortConfiguration = null The sort configuration
 * @property null|ReportConfigTypeEnum $type = null The config type
 */
final class ReportConfigInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'builtInReport') {
            return new BuiltInReportEnum($value);
        }

        if ($name === 'filters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new FieldFilterInputInputType($v)); })($value);
        }

        if ($name === 'orderedVisibleColumns') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new FieldDescriptionInputInputType($v)); })($value);
        }

        if ($name === 'paging') {
            return new PagingInputInputType($value);
        }

        if ($name === 'searchConfig') {
            return new SearchConfigurationInputInputType($value);
        }

        if ($name === 'sortConfiguration') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new SortEntryInputInputType($v)); })($value);
        }

        if ($name === 'type') {
            return new ReportConfigTypeEnum($value);
        }

        return $value;
    }
}