<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type ThycoticSecretServer
 * This object contains information about the Delinea secret server. */
final class ThycoticSecretServerType implements AutoGenerationInterface, PasswordManagerServerInterface
{
    /**
     * The list of folders
     * @var null|iterable
     */
    public ?iterable $folders = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * A flag that indicates whether the Delinea server is hosted in the cloud.
     */
    public ?bool $isCloudServer = null;
    /**
     * The server's descriptive name as provided by the user.
     */
    public ?string $name = null;
    /**
     * The account's password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
     */
    public ?string $password = null;
    /**
     * The port that the server is listening on.
     */
    public ?int $port = null;
    /**
     * Search by the hostname only when searching for a device account. Note that a hostname might be not unique within different domains!
     */
    public ?bool $searchByHostname = null;
    /**
     * The server's address (IP address or hostname).
     */
    public ?string $serverAddress = null;
    /**
     * The server status
     */
    public ?PasswordManagementStatusType $status = null;
    /**
     * A flag whether the secret server should be used to get accounts for individual devices based on IP or hostname.
     */
    public ?bool $useDeviceAccounts = null;
    /**
     * The username used to authenticate against the Delinea server..
     */
    public ?string $username = null;
    /**
     * The server label
     */
    public ?string $label = null;
}