<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type TriggerDiscovery
 */
final class TriggerDiscoveryType implements AutoGenerationInterface
{
    /**
     * Triggers the scan for an IP address or hostname. Returns true when the device has been added to the queue or false,
if - for instance - the hostname could not be resolved

Required permissions: DiscoverSingleDevice, ControlDiscovery
     * @var null|iterable
     */
    public ?iterable $triggerDeviceScan = null;
    /**
     * Triggers the scan for the given IP addresses or hostnames. Returns true when the device has been added to the queue or false,
if - for instance - the hostname could not be resolved

Required permissions: DiscoverSingleDevice, ControlDiscovery
     * @var null|iterable
     */
    public ?iterable $triggerDevicesScan = null;
    /**
     * Triggers the scan for an existing device. The device is identified by its id (embedded in the DeviceReference)When lookupDeviceFirst is true, then it performs DNS lookup on the hostname then then adds the resulting IP address to the discovery (good for DHCP).
Otherwise, it just adds the device's current IP addresses to the queue.

The method returns a status object with a DeviceQueueItem object. The device queue item object can be called to
poll the current status from the device queue.

Required permissions: DiscoverSingleDevice, ControlDiscovery
     * @var null|iterable
     */
    public ?iterable $triggerExistingDeviceScan = null;
    /**
     * Triggers the scan for an existing device. The device is identified by its id (embedded in the DeviceReference)
When lookupDeviceFirst is true, then it performs DNS lookup on the hostname then then adds the resulting IP address to the discovery (good for DHCP).
Otherwise, it just adds the device's current IP addresses to the queue.

Required permissions: ControlDiscovery
     * @var null|iterable
     */
    public ?iterable $triggerExistingDevicesScan = null;
    /**
     * Triggers the scan for an existing device. The device is identified by its id (embedded in the DeviceReference)
When lookupDeviceFirst is true, then it performs DNS lookup on the hostname then then adds the resulting IP address to the discovery (good for DHCP).
Otherwise, it just adds the device's current IP addresses to the queue.

This method is executed asynchronously and will return a progress callback object

Required permissions: ControlDiscovery
     */
    public ?DefaultProgressInfoType $triggerExistingDevicesScanAsync = null;
}