<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\FeatureManager\FeatureManager;

if (include_once('isys_module_notifications_autoload.class.php')) {
    spl_autoload_register('isys_module_notifications_autoload::init');
}
if (FeatureManager::isFeatureActive('notification-settings')) {
    isys_application::instance()->container->get('settingsTenant')
        ->extend([
            'LC__MODULE__NOTIFICATIONS' => [
                'idoit.notifications.license-expiration.skip-expired' => [
                    'title'   => 'LC__NOTIFICATION_TYPE__LICENSE_EXPIRATION__SKIP_EXPIRED',
                    'type'    => 'select',
                    'options' => [
                        '0' => 'LC__UNIVERSAL__NO',
                        '1' => 'LC__UNIVERSAL__YES'
                    ],
                    'default' => '0'
                ]
            ]
        ]);
}
