<?php

namespace idoit\Module\Pro\Controller\Center\ContractCenter;

use isys_application;
use isys_component_template;
use isys_module_pro;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Controller for 'contact us' popup.
 *
 * @package   Modules
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ContactUs
{
    private isys_component_template $template;

    public function __construct()
    {
        $this->template = isys_application::instance()->container->get('template');
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function display(Request $request): Response
    {
        $templateContent = $this->template
            ->assign('email', 'sales@i-doit.com')
            ->assign('phoneNumber', '+49 (0) 211 - 699 31 185')
            ->fetch(isys_module_pro::getPath() . '/templates/SettingPage/Center/Contract/contact-us-popup.tpl');

        return new Response($templateContent);
    }
}
