<?php
/**
 * i-doit
 *
 * Smarty plugin for object images. Returns a string with the source of the image.
 *
 * @package     i-doit
 * @subpackage  Smarty_Plugins
 * @author      Niclas Potthast <npotthast@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

define("C__IMAGE_SIZE__THUMB", "28px");
define("C__IMAGE_SIZE__NORMAL", "100px");

class isys_smarty_plugin_object_image extends isys_smarty_plugin_f implements isys_smarty_plugin
{
    /**
     * @param string $p_filename
     * @param int    $p_objectType
     *
     * @return string
     * @throws isys_exception_filesystem
     * @deprecated
     */
    public static function get_user_defined_image_url_by_file($p_filename, $p_objectType = null)
    {
        global $g_dirs;

        $l_dlgets[C__GET__MODULE_ID] = defined_or_default('C__MODULE__CMDB');
        $l_dlgets[C__GET__FILE_MANAGER] = "image";

        if (!empty($p_filename) && file_exists(isys_application::instance()->getUploadImagePath($p_filename))) {
            $l_dlgets["file"] = $p_filename;

            return '?' . isys_glob_http_build_query($l_dlgets);
        }

        return isys_application::instance()->container->get('route_generator')->generate('cmdb.object-type.image', ['objectTypeId' => (int)$p_objectType]);
    }

    /**
     * @param int $p_objID
     *
     * @return string
     * @deprecated Don't use this. Please refer to the route 'cmdb.object.image'.
     */
    public static function get_user_defined_image_url_by_id($p_objID)
    {
        return isys_application::instance()->container->get('route_generator')->generate('cmdb.object.image', ['objectId' => (int)$p_objID]);
    }

    /**
     * Defines wheather the sm2 meta map is enabled or not.
     *
     * @return  boolean
     */
    public function enable_meta_map()
    {
        return false;
    }

    /**
     * Return the image to an objecttype (or object - todo).
     *
     * @param    isys_component_template &$p_tplclass
     * @param    array                   $p_params
     *
     * @return   string
     * @author   Niclas Potthast <npotthast@i-doit.org>
     */
    public function navigation_view(isys_component_template $p_tplclass, $p_params = null)
    {
        global $g_config;

        if ($p_params === null) {
            $p_params = $this->m_parameter;
        }

        $this->m_strPluginClass = "object_image";
        $this->m_strPluginName = $p_params["name"];

        if (empty($p_params["objType"])) {
            $l_nObjTypeID = $_GET["objTypeID"];
        } else {
            $l_nObjTypeID = $p_params["objType"];
            $l_nObjID = null;
        }

        if (empty($p_params[C__CMDB__GET__OBJECT])) {
            $l_nObjID = $_GET[C__CMDB__GET__OBJECT];
        } else {
            $l_nObjID = $p_params[C__CMDB__GET__OBJECT];
        }

        // Get user image.
        $width = null;
        $height = null;

        if ($p_params["p_bThumb"] == "1" || $_SESSION["viewMode"]["contentTop"] == "off") {
            $width = C__IMAGE_SIZE__THUMB;
            $height = C__IMAGE_SIZE__THUMB;
        }

        if ($p_params["width"]) {
            $width = $p_params["width"];
        }

        if ($p_params["height"]) {
            $height = $p_params["height"];
        }

        $attributes = [
            'src="' . isys_application::instance()->container->get('route_generator')->generate('cmdb.object.image', ['objectId' => (int)$l_nObjID]) . '"',
            'alt="' . $p_params["alt"] . '"'
        ];

        if (!empty($p_params["class"])) {
            $attributes[] = 'class="' . $p_params["class"] . '"';
        }

        if (!empty($p_params["style"])) {
            $attributes[] = 'style="' . $p_params["style"] . '"';
        }

        if (!empty($p_params["align"])) {
            $attributes[] = 'align="' . $p_params["align"] . '"';
        }

        if (!empty($width)) {
            $attributes[] = 'width="' . $width . '"';
        }

        if (!empty($height)) {
            $attributes[] = 'height="' . $height . '"';
        }

        return '<img id="object_image_header" ' . implode(' ', array_filter($attributes)) . ' />';
    }

    /**
     * @param   isys_component_template &$p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function navigation_edit(isys_component_template $p_tplclass, $p_params = null)
    {
        return $this->navigation_view($p_tplclass, $p_params);
    }
}
