<?php

namespace idoit\Component\Upload\Types;

use Exception;
use Intervention\Image\ImageManager;
use isys_application;

/**
 * Class ObjectTypeImage
 *
 * @package idoit\Component\Upload\Types
 */
class ObjectTypeImage
{
    /**
     * Method for processing the object type icon.
     *
     * @param string $imagePath
     *
     * @return string
     * @throws Exception
     */
    public static function processUpload(string $imagePath): string
    {
        // @see ID-9226 No need to process SVG files.
        if (pathinfo($imagePath, PATHINFO_EXTENSION) !== 'svg') {
            (new ImageManager())->make($imagePath)
                ->resize(200, 200, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })
                ->save($imagePath);
        }

        return isys_application::instance()->container->get('route_generator')
            ->generate('cmdb.object-type.image-name', ['filename' => basename($imagePath)]);
    }
}
