<?php
/**
 * Template for Barcode popup.
 *
 * @package     i-doit
 * @subpackage  General
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

$objectId = filter_input(INPUT_GET, 'object', FILTER_VALIDATE_INT) ?: 0;
?>
<!doctype html>
<html lang="en">
<head>
    <title>i-doit barcode</title>
    <meta name="author" content="synetics gmbh" />
    <meta name="description" content="i-doit" />

    <script type="text/javascript" language="JavaScript" src="../js/prototype/prototype.js"></script>
    <script type="text/javascript" language="JavaScript" src="../js/scriptaculous/src/scriptaculous.js?load=effects"></script>

    <style>
        body {
            font-family: "Lucida Grande", Tahoma, Arial, Helvetica, sans-serif;
            color: #000;
            font-size: 10pt;
        }

        p {
            margin: 5px 0;
        }

        .text-center {
            text-align: center;
        }

        .animation-rotate {
            animation-name: animateRotation;
            animation-duration: 750ms;
            animation-timing-function: ease-out;
            animation-iteration-count: infinite;
            visibility: visible !important;
        }

        @keyframes animateRotation {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }
    </style>
</head>
<body id="body">

<div class="text-center">
    <img id="barcode_image" src="../../../images/axialis/user-interface/loading.svg" class="animation-rotate" alt="Error loading barcode image" />
    <p id="sysid"></p>
</div>

<script type="text/javascript" language="JavaScript">
    new Ajax.Request('../../../?ajax=1&call=qrcode&func=load_qr_code', {
        method: 'post',
        parameters: {
            objID: <?php echo $objectId; ?>
        },
        onSuccess: function (response) {
            const json = response.responseJSON;

            if (json === null) {
                $('body').innerHTML = '<h1>URL is not returning a valid response.</h1>';
                return;
            }

            $('barcode_image')
                .removeClassName('animation-rotate')
                .writeAttribute('alt', 'Barcode')
                .writeAttribute('src', json.data.barcodeUrl);

            $('sysid').update(json.data.sysid)

            // We need this timer for the browser to correctly detect the image heights...
            setTimeout(() => {
                if (window.print) {
                    window.print();
                }
            }, 100);
        }
    });
</script>
</body>
</html>
