<?php
/**
 * Template for QR Code popup.
 *
 * @package     i-doit
 * @subpackage  General
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

$objectId = filter_input(INPUT_GET, 'object', FILTER_VALIDATE_INT) ?: 0;
?>
<!doctype html>
<html lang="en">
<head>
    <title>i-doit barcode</title>
    <meta name="author" content="synetics gmbh" />
    <meta name="description" content="i-doit" />

    <script type="text/javascript" language="JavaScript" src="../../js/prototype/prototype.js"></script>
    <script type="text/javascript" language="JavaScript" src="../../js/scriptaculous/src/scriptaculous.js?load=effects"></script>

    <style>
        body {
            font-family: "Lucida Grande", Tahoma, Arial, Helvetica, sans-serif;
            color: #000;
            font-size: 10pt;
        }

        #code, #logo {
            text-align: center;
        }

        #logo {
            margin: 5px;
        }

        #description {
            margin: 0;
        }

        #code.after-loading {
            width: 70px;
            padding: 10px;
        }

        .animation-rotate {
            animation-name: animateRotation;
            animation-duration: 750ms;
            animation-timing-function: ease-out;
            animation-iteration-count: infinite;
            visibility: visible !important;
        }

        @keyframes animateRotation {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }
    </style>
</head>
<body id="body">

<table id="qrcode">
    <tr>
        <td>
            <img id="code" src="../../../../images/axialis/user-interface/loading.svg" class="animation-rotate" alt="Error loading the QR Code" />
        </td>
        <td>
            <div id="description"></div>
        </td>
        <td>
            <img id="logo" src="../../../../images/axialis/user-interface/loading.svg" class="animation-rotate" alt="" />
        </td>
    </tr>
</table>

<script type="text/javascript">
    new Ajax.Request('../../../../?ajax=1&call=qrcode&func=load_qr_code', {
        method:     'post',
        parameters: {
            objID: <?php echo $objectId; ?>
        },
        onSuccess:  function (response) {
            const json = response.responseJSON;

            if (json === null) {
                $('body').innerHTML = '<h1>URL is not returning a valid response.</h1>';
                return;
            }

            $('code')
                .removeClassName('animation-rotate')
                .addClassName('after-loading')
                .writeAttribute('alt', 'QR-Code')
                .writeAttribute('src', json.data.qrcodeUrl);

            $('logo')
                .removeClassName('animation-rotate')
                .writeAttribute('src', json.data.logo);

            if (json.data.description) {
                $('description').update(json.data.description);
            }

            // We need this timer for the browser to correctly detect the image heights...
            setTimeout('calc_sizes_and_print()', 100);
        }
    });

    function calc_sizes_and_print() {
        // Now we try to set the logo to the same size as the QR Code.
        $('logo').writeAttribute('height', $('code').getHeight() + 'px');

        if (window.print) {
            window.print();
        }
    }
</script>
</body>
</html>
