--
-- i-doit system dump for version 34
--
-- For manual installations you need to insert your tenant connection info into isys_mandator in order to connect to a tenant.
--
-- INSERT INTO isys_mandator SET
--   isys_mandator__title = 'Mandator (DE)',
--   isys_mandator__dir_cache = 'cache_mandator',
--   isys_mandator__dir_tpl = 'default',
--   isys_mandator__db_host = 'localhost',
--   isys_mandator__db_port = 3306,
--   isys_mandator__db_name = 'idoit_data',
--   isys_mandator__db_user = 'idoit',
--   isys_mandator__db_pass = 'idoit',
--   isys_mandator__active = 1;
--

SET FOREIGN_KEY_CHECKS = 0;
SET GLOBAL innodb_default_row_format = DYNAMIC;

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_const_get` (
  `isys_const_get__id` int(11) NOT NULL AUTO_INCREMENT,
  `isys_const_get__title` varchar(255) NOT NULL DEFAULT '',
  `isys_const_get__description` text DEFAULT NULL,
  `isys_const_get__value` text DEFAULT NULL,
  `isys_const_get__quoted` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`isys_const_get__id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_const_get` VALUES (1,'C__CMDB__GET__VIEWMODE',NULL,'viewMode',1);
INSERT INTO `isys_const_get` VALUES (2,'C__CMDB__GET__TREEMODE',NULL,'tvMode',1);
INSERT INTO `isys_const_get` VALUES (3,'C__CMDB__GET__OBJECTGROUP',NULL,'objGroupID',1);
INSERT INTO `isys_const_get` VALUES (4,'C__CMDB__GET__OBJECTTYPE',NULL,'objTypeID',1);
INSERT INTO `isys_const_get` VALUES (5,'C__CMDB__GET__OBJECT',NULL,'objID',1);
INSERT INTO `isys_const_get` VALUES (6,'C__CMDB__GET__CATTYPE',NULL,'catTypeID',1);
INSERT INTO `isys_const_get` VALUES (7,'C__CMDB__GET__CATG',NULL,'catgID',1);
INSERT INTO `isys_const_get` VALUES (8,'C__CMDB__GET__CATS',NULL,'catsID',1);
INSERT INTO `isys_const_get` VALUES (9,'C__CMDB__GET__CATD',NULL,'catdID',1);
INSERT INTO `isys_const_get` VALUES (10,'C__CMDB__GET__POPUP',NULL,'popup',1);
INSERT INTO `isys_const_get` VALUES (11,'C__CMDB__GET__CAT_MENU_SELECTION',NULL,'catMenuSelection',1);
INSERT INTO `isys_const_get` VALUES (12,'C__CMDB__GET__EDITMODE',NULL,'editMode',1);
INSERT INTO `isys_const_get` VALUES (13,'C__CMDB__GET__CAT_LIST_VIEW',NULL,'catListView',1);
INSERT INTO `isys_const_get` VALUES (14,'C__CMDB__GET__CATLEVEL',NULL,'cateID',1);
INSERT INTO `isys_const_get` VALUES (15,'C__CMDB__GET__CATLEVEL_1',NULL,'cat1ID',1);
INSERT INTO `isys_const_get` VALUES (16,'C__CMDB__GET__CATLEVEL_2',NULL,'cat2ID',1);
INSERT INTO `isys_const_get` VALUES (17,'C__CMDB__GET__CATLEVEL_3',NULL,'cat3ID',1);
INSERT INTO `isys_const_get` VALUES (18,'C__CMDB__GET__CATLEVEL_4',NULL,'cat4ID',1);
INSERT INTO `isys_const_get` VALUES (19,'C__CMDB__GET__CATLEVEL_5',NULL,'cat5ID',1);
INSERT INTO `isys_const_get` VALUES (20,'C__CMDB__GET__CATLEVEL_MAX',NULL,'5',1);
INSERT INTO `isys_const_get` VALUES (21,'C__GET__FILE_MANAGER',NULL,'file_manager',1);
INSERT INTO `isys_const_get` VALUES (22,'C__GET__MODULE_ID',NULL,'moduleID',1);
INSERT INTO `isys_const_get` VALUES (23,'C__GET__NAVMODE',NULL,'navMode',1);
INSERT INTO `isys_const_get` VALUES (24,'C__GET__FILE_NAME',NULL,'file_name',1);
INSERT INTO `isys_const_get` VALUES (25,'C__GET__AJAX_REQUEST',NULL,'ajax_request_func',1);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_const_system` (
  `isys_const_system__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_const_system__const` varchar(255) NOT NULL DEFAULT '',
  `isys_const_system__value` int(10) unsigned DEFAULT 1,
  `isys_const_system__description` text DEFAULT NULL,
  `isys_const_system__store_id` int(10) unsigned NOT NULL DEFAULT 0,
  `isys_const_system__doku_cross_reference` text DEFAULT NULL,
  PRIMARY KEY (`isys_const_system__id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_const_system` VALUES (1,'C__NAVBAR_BUTTON__DELETE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (3,'C__NAVMODE__NEW',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (4,'C__NAVMODE__EDIT',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (5,'C__NAVMODE__DUPLICATE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (7,'C__NAVMODE__BACK',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (8,'C__NAVMODE__FORWARD',9,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (9,'C__NAVMODE__SAVE',10,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (10,'C__NAVMODE__RESET',13,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (11,'C__NAVMODE__CANCEL',14,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (29,'C__RECORD_PROPERTY__NOT_SHOW_IN_LIST',16,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (40,'C__NAVBAR_BUTTON__NEW',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (41,'C__NAVBAR_BUTTON__EDIT',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (43,'C__NAVBAR_BUTTON__DUPLICATE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (45,'C__NAVBAR_BUTTON__BACK',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (47,'C__NAVBAR_BUTTON__FORWARD',9,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (48,'C__RECORD_STATUS__BIRTH',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (49,'C__RECORD_STATUS__NORMAL',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (50,'C__RECORD_STATUS__ARCHIVED',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (51,'C__RECORD_STATUS__DELETED',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (54,'C__EDITMODE__ON',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (55,'C__EDITMODE__OFF',0,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (56,'C__NAVBAR_BUTTON__RECYCLE',12,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (59,'C__RECORD_STATUS__PURGE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (60,'C__MPTT__ACTION_BEGIN',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (61,'C__MPTT__ACTION_END',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (62,'C__MPTT__ACTION_ADD',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (63,'C__MPTT__ACTION_DELETE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (64,'C__MPTT__ACTION_MOVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (65,'C__MPTT__ROOT_NODE',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (66,'C__MPTT__ACTION_UPDATE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (72,'C__NAVMODE__ARCHIVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (73,'C__NAVBAR_BUTTON__ARCHIVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (74,'C__NAVMODE__PURGE',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (75,'C__NAVBAR_BUTTON__PURGE',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (76,'C__NAVMODE__RECYCLE',12,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (77,'C__LINK__OBJECT',1,NULL,1,NULL);
INSERT INTO `isys_const_system` VALUES (80,'C__LINK__CATG',2,NULL,1,NULL);
INSERT INTO `isys_const_system` VALUES (83,'C__NAVMODE__PRINT',15,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (84,'C__NAVBAR_BUTTON__PRINT',15,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (85,'C__NAVMODE__DELETE',5,'',0,NULL);
INSERT INTO `isys_const_system` VALUES (86,'C__NAVMODE__JS_ACTION',16,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (87,'C__RECORD_STATUS__TEMPLATE',6,'',0,NULL);
INSERT INTO `isys_const_system` VALUES (88,'C__NAVBAR_BUTTON__COMPLETE',20,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (89,'C__NAVMODE__COMPLETE',20,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (90,'C__RECORD_STATUS__MASS_CHANGES_TEMPLATE',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (91,'C__NAVBAR_BUTTON__SAVE',21,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (92,'C__NAVBAR_BUTTON__CANCEL',22,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (93,'C__NAVBAR_BUTTON__QUICK_PURGE',60,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (94,'C__NAVMODE__QUICK_PURGE',60,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (95,'C__NAVBAR_BUTTON__EXPORT_AS_CSV',17,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (96,'C__NAVMODE__EXPORT_CSV',17,NULL,0,NULL);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_db_init` (
  `isys_db_init__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_db_init__key` varchar(255) NOT NULL,
  `isys_db_init__value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`isys_db_init__id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_db_init` VALUES (1,'title','i-doit 34');
INSERT INTO `isys_db_init` VALUES (2,'revision','202434000');
INSERT INTO `isys_db_init` VALUES (3,'version','34');
INSERT INTO `isys_db_init` VALUES (4,'type','pro');
INSERT INTO `isys_db_init` VALUES (5,'required_revision','202429000');
INSERT INTO `isys_db_init` VALUES (6,'required_version','29');
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_language` (
  `isys_language__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_language__title` varchar(255) DEFAULT NULL,
  `isys_language__short` varchar(8) NOT NULL,
  `isys_language__icon` varchar(255) DEFAULT NULL,
  `isys_language__available` int(1) NOT NULL,
  `isys_language__const` varchar(100) DEFAULT NULL,
  `isys_language__sort` int(10) NOT NULL,
  PRIMARY KEY (`isys_language__id`),
  UNIQUE KEY `isys_language__short` (`isys_language__short`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_language` VALUES (2,'LC__LANGUAGE_GERMAN','de','axialis/flags-languages/flag-germany.svg',1,'ISYS_LANGUAGE_GERMAN',1);
INSERT INTO `isys_language` VALUES (3,'LC__LANGUAGE_ENGLISH','en','axialis/flags-languages/flag-united-states.svg',1,'ISYS_LANGUAGE_ENGLISH',2);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_licence` (
  `isys_licence__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_licence__isys_mandator__id` int(10) unsigned DEFAULT NULL,
  `isys_licence__isys_licence__id` int(10) unsigned DEFAULT NULL,
  `isys_licence__contract` varchar(10) DEFAULT NULL,
  `isys_licence__type` int(10) NOT NULL,
  `isys_licence__key` longtext DEFAULT NULL,
  `isys_licence__data` longtext DEFAULT NULL,
  `isys_licence__expires` datetime DEFAULT NULL,
  `isys_licence__datetime` datetime DEFAULT NULL,
  `isys_licence__license_objects` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`isys_licence__id`),
  KEY `isys_licence__isys_mandator__id` (`isys_licence__isys_mandator__id`),
  CONSTRAINT `isys_licence_ibfk_1` FOREIGN KEY (`isys_licence__isys_mandator__id`) REFERENCES `isys_mandator` (`isys_mandator__id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_licence_communication` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` int(3) unsigned NOT NULL,
  `licenses_count` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_mandator` (
  `isys_mandator__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_mandator__title` varchar(255) DEFAULT NULL,
  `isys_mandator__description` text DEFAULT NULL,
  `isys_mandator__dir_cache` varchar(255) DEFAULT NULL,
  `isys_mandator__dir_tpl` varchar(255) DEFAULT NULL,
  `isys_mandator__db_host` varchar(255) DEFAULT NULL,
  `isys_mandator__db_port` int(11) DEFAULT 3306,
  `isys_mandator__db_name` varchar(255) DEFAULT NULL,
  `isys_mandator__db_user` varchar(255) NOT NULL DEFAULT '',
  `isys_mandator__db_pass` varchar(255) DEFAULT NULL,
  `isys_mandator__db_password` varchar(255) DEFAULT NULL,
  `isys_mandator__apikey` varchar(100) DEFAULT NULL,
  `isys_mandator__sort` int(10) unsigned DEFAULT NULL,
  `isys_mandator__active` int(10) unsigned DEFAULT 1,
  `isys_mandator__license_objects` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`isys_mandator__id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_settings` (
  `isys_settings__key` varchar(255) NOT NULL,
  `isys_settings__value` text NOT NULL,
  `isys_settings__isys_mandator__id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`isys_settings__key`,`isys_settings__isys_mandator__id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_settings` VALUES ('admin.active_license_distribution','1',0);
INSERT INTO `isys_settings` VALUES ('api.authenticated-users-only','0',0);
INSERT INTO `isys_settings` VALUES ('api.status','1',0);
INSERT INTO `isys_settings` VALUES ('api.strip-tags','0',0);
INSERT INTO `isys_settings` VALUES ('api.validation','1',0);
INSERT INTO `isys_settings` VALUES ('auth.active','1',0);
INSERT INTO `isys_settings` VALUES ('auth.logging','0',0);
INSERT INTO `isys_settings` VALUES ('auth.use-in-cmdb-explorer','0',0);
INSERT INTO `isys_settings` VALUES ('barcode.enabled','1',0);
INSERT INTO `isys_settings` VALUES ('barcode.type','qr',0);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__CMDB__OBJTYPE__CABLE_TRAY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__CMDB__OBJTYPE__CONDUIT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJECT_TYPE__GROUP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ACCESS_POINT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"ssid\",\"isys_cats_access_point_list__ssid\",\"LC__CMDB__CATS__ACCESS_POINT_SSID\",\"isys_cmdb_dao_category_s_access_point::get_properties\",false,\"LC__CMDB__CATS__ACCESS_POINT\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AIR_CONDITION_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_ac_type__title\",\"LC__CATS__AC_TYPE\",\"isys_cmdb_dao_category_s_ac::get_properties\",false,\"LC__CMDB__CATS__AC\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AIRCRAFT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AMPLIFIER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__APPLIANCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__APPLICATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BLADE_CHASSIS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_chassis_slot_list__title\",\"LC__CMDB__CATG__GLOBAL_TITLE\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"assigned_devices\",\"isys_cats_chassis_slot_list__id\",\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BLADE_SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BUILDING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"street\",\"isys_catg_address_list__street\",\"LC__CONTACT__ORGANISATION_STREET\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"postcode\",\"isys_catg_address_list__postalcode\",\"LC__CONTACT__ORGANISATION_POSTAL_CODE\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"city\",\"isys_catg_address_list__city\",\"LC__CONTACT__ORGANISATION_CITY\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CABLE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"connection\",\"isys_catg_cable_list__id__isys_obj__id\",\"LC__CATS__CABLE__CONNECTION\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"cable_type\",\"isys_cable_type__title\",\"LC__CMDB__CATS__CABLE__TYPE\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"length\",\"isys_catg_cable_list__length\",\"LC__CMDB__CATS__CABLE__LENGTH\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CELL_PHONE_CONTRACT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"serial\",\"isys_catg_model_list__serial\",\"LC__CMDB__CATG__SERIAL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"imei_number\",\"isys_cats_mobile_phone_list__imei_number\",\"LC__CMDB__CATS__SIM_CARD__IMEI_NUMBER\",\"isys_cmdb_dao_category_s_cp_contract::get_properties\",false,\"LC__CMDB__CATS__CELL_PHONE_CONTRACT\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CITY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLIENT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_contact\",\"isys_connection__title\",\"LC__CATG__CONTACT_PRIMARY\",\"isys_cmdb_dao_category_g_contact::get_properties\",false,\"LC__CMDB__CATG__CONTACT\",null],[1,\"type\",\"isys_client_type__title\",\"LC__CMDB__CATS__CLIENT_TYPE\",\"isys_cmdb_dao_category_s_client::get_properties\",false,\"LC__CMDB__CATS__CLIENT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cluster_members\",\"isys_catg_cluster_members_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER_MEMBERS\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"cluster_service\",\"isys_catg_cluster_service_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER_SERVICES\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"administration_service\",\"isys_catg_cluster_adm_service_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER__ADMINISTRATION_SERVICE\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cluster\",\"isys_catg_cluster_service_list__isys_obj__id\",\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"runs_on\",\"isys_catg_cluster_service_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__RUNS_ON\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"type\",\"isys_cluster_type__title\",\"LC__CMDB__CATG__CLUSTER_SERVICE__TYPE\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER_VRRP_HSRP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CONVERTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__COUNTRY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DATABASE_INSTANCE','[[1,\"title\",\"isys_obj__title\",\"Name (Allgemein)\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_database_instance_list__title\",\"Name (Instanz \\/ Oracle Datenbank)\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"listener\",\"isys_cats_database_instance_list__listener\",\"Listener\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"instance\",\"isys_connection__title\",\"DBMS\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DATABASE_SCHEMA','[[1,\"title\",\"isys_obj__title\",\"Name (Allgemein)\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"storage_engine\",\"isys_cats_database_schema_list__storage_engine\",\"Storage-Engine\",\"isys_cmdb_dao_category_s_database_schema::get_properties\",false,\"LC__OBJTYPE__DATABASE_SCHEMA\",null],[1,\"title\",\"isys_cats_database_objects_list__title\",\"Name (Datenbankobjekte)\",\"isys_cmdb_dao_category_s_database_objects::get_properties\",false,\"LC__CMDB__TREE__DATABASE_OBJECTS\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DBMS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DISTRIBUTION_BOX','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__EMERGENCY_PLAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ENCLOSURE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"rackunits\",\"isys_catg_formfactor_list__rackunits\",\"LC__CMDB__CATG__RACKUNITS\",\"isys_cmdb_dao_category_g_formfactor::get_properties\",false,\"LC__CMDB__CATG__FORMFACTOR\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"vertical_slots_front\",\"isys_cats_enclosure_list__vertical_slots_front\",\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONTSIDE\",\"isys_cmdb_dao_category_s_enclosure::get_properties\",false,\"LC__CMDB__CATS__ENCLOSURE\",null],[1,\"vertical_slots_rear\",\"isys_cats_enclosure_list__vertical_slots_rear\",\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_BACKSIDE\",\"isys_cmdb_dao_category_s_enclosure::get_properties\",false,\"LC__CMDB__CATS__ENCLOSURE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__EPS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ESC','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"volt\",\"isys_catg_power_supplier_list__volt\",\"LC__CMDB__CATG__POWER_SUPPLIER__VOLT\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"watt\",\"isys_catg_power_supplier_list__watt\",\"LC__CMDB__CATG__POWER_SUPPLIER__WATT\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"ampere\",\"isys_catg_power_supplier_list__ampere\",\"LC__CMDB__CATG__POWER_SUPPLIER__AMPERE\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"connector\",\"con_connector\",\"LC__CATG__CONNECTOR__ASSIGNED_CONNECTOR\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__FC_SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"target\",\"isys_catg_fc_port_list__isys_catg_connector_list__id\",\"LC__CMDB__CATG__NETWORK__TARGET_OBJECT\",\"isys_cmdb_dao_category_g_controller_fcport::get_properties\",false,\"LC__STORAGE_FCPORT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__FILE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__HOST','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__IT_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"its_type\",\"isys_its_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_g_its_type::get_properties\",false,\"LC__CMDB__CATG__ITS_TYPE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__KRYPTO_CARD','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"date_of_issue\",\"isys_cats_krypto_card_list__date_of_issue\",\"LC__CMDB__CATS__KRYPTO_CARD__DATE_OF_ISSUE\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"certgate_card_number\",\"isys_cats_krypto_card_list__certgate_card_number\",\"LC__CMDB__CATS__KRYPTO_CARD__CERTGATE_CARD_NUMBER\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"imei_number\",\"isys_cats_krypto_card_list__imei_number\",\"LC__CMDB__CATS__KRYPTO_CARD__IMEI_NUMBER\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__KVM_SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LAYER2_NET','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"vlan_id\",\"isys_cats_layer2_net_list__ident\",\"LC__CMDB__CATS__LAYER2_ID\",\"isys_cmdb_dao_category_s_layer2_net::get_properties\",false,\"LC__CMDB__CATS__LAYER2_NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LAYER3_NET','[[1,\"ip_address_link\",\"isys_cats_net_ip_addresses_link__isys_obj__id\",\"LC__CMDB__IP__URL_TITLE\",\"isys_cmdb_dao_category_s_net_ip_addresses::get_properties\",false,\"LC__CMDB__CATS__NET_IP_ADDRESSES\",null],[1,\"type\",\"isys_net_type__title\",\"LC__CMDB__CATS__NET__TYPE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_with_suffix\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_range\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_RANGE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"netmask\",\"isys_cats_net_list__mask\",\"LC__CMDB__CATS__NET__MASK\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"free_addresses\",\"isys_obj__id\",\"LC__CMDB__CATG__NETWORK__ASS_IP\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LICENCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"amount\",\"isys_cats_lic_list__amount\",\"LC__CMDB__CATS__LICENCE_AMOUNT\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"lic_not_in_use\",\"isys_cats_lic_list__id\",\"LC__CMDB__CATS__LICENCE_FREE\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"type\",\"isys_cats_lic_list__type\",\"LC__CMDB__CATS__LICENCE_TYPE\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MAINTENANCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_contract_type__title\",\"LC__CMDB__CATS__CONTRACT__TYPE\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"contract_status\",\"isys_contract_status__title\",\"LC__CMDB__CATS__CONTRACT__STATUS\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"run_time\",\"isys_cats_contract_list__runtime\",\"LC__CMDB__CATG__LEASING__RUNTIME\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MIDDLEWARE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MIGRATION_OBJECT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MONITOR','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_HOST_TPL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_SERVICE_TPL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__OPERATING_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ORGANIZATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"street\",\"isys_catg_address_list__street\",\"LC__CONTACT__ORGANISATION_STREET\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"postcode\",\"isys_catg_address_list__postalcode\",\"LC__CONTACT__ORGANISATION_POSTAL_CODE\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"city\",\"isys_catg_address_list__city\",\"LC__CONTACT__ORGANISATION_CITY\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"telephone\",\"isys_cats_organization_list__telephone\",\"LC__CONTACT__ORGANISATION_PHONE\",\"isys_cmdb_dao_category_s_organization_master::get_properties\",false,\"LC__CMDB__CATS__ORGANIZATION_MASTER_DATA\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PARALLEL_RELATION','[[1,\"title\",false,\"LC__UNIVERSAL__TITLE_LINK\",\"isys_cmdb_dao_category_g_global::get_properties\",[\"isys_cmdb_dao_category_g_global\",\"dynamic_property_callback_title\"],null,null],[1,\"threshold\",\"isys_cats_relpool_list__threshold\",\"LC__CATS__AC_THRESHOLD\",\"isys_cmdb_dao_category_s_parallel_relation::get_properties\",false,null,null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PATCH_PANEL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PDU','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_catg_connector_list__title\",\"LC__CMDB__CATG__TITLE\",\"isys_cmdb_dao_category_g_connector::get_properties\",false,\"LC__CMDB__CATG__CONNECTORS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PERSON','[[1,\"last_name\",\"isys_cats_person_list__last_name\",\"LC__CONTACT__PERSON_LAST_NAME\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"first_name\",\"isys_cats_person_list__first_name\",\"LC__CONTACT__PERSON_FIRST_NAME\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"department\",\"isys_cats_person_list__department\",\"LC__CONTACT__PERSON_DEPARTMENT\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"phone_company\",\"isys_cats_person_list__phone_company\",\"LC__CONTACT__PERSON_TELEPHONE_COMPANY\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"mail\",\"isys_catg_mail_addresses_list__title\",\"LC__CONTACT__PERSON_MAIL_ADDRESS\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"title\",\"isys_cats_person_list__title\",\"LC__CONTACT__PERSON_USER_NAME\",\"isys_cmdb_dao_category_s_person_login::get_properties\",false,\"LC__UNIVERSAL__LOGIN\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PERSON_GROUP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"email_address\",\"isys_catg_mail_addresses_list__title\",\"LC__CONTACT__GROUP_EMAIL_ADDRESS\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"phone\",\"isys_cats_person_group_list__phone\",\"LC__CONTACT__GROUP_PHONE\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"ldap_group\",\"isys_cats_person_group_list__ldap_group\",\"LC__CMDB__CATS__PERSON_GROUPS__LDAP_MAPPING\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PHONE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"extension\",\"isys_catg_telephone_fax_list__extension\",\"LC__CMDB__CATG__TELEPHONE_FAX__EXTENSION\",\"isys_cmdb_dao_category_g_telephone_fax::get_properties\",false,\"LC__CMDB__CATG__TELEPHONE_FAX\",null],[1,\"telephone_number\",\"isys_catg_telephone_fax_list__telephone_number\",\"LC__CMDB__CATG__TELEPHONE_FAX__TELEPHONE_NUMBER\",\"isys_cmdb_dao_category_g_telephone_fax::get_properties\",false,\"LC__CMDB__CATG__TELEPHONE_FAX\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PRINTBOX','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PRINTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_cats_prt_type__title\",\"LC__CMDB__CATS__PRT_TYPE\",\"isys_cmdb_dao_category_s_prt::get_properties\",false,\"LC__CMDB__CATS__PRT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__RELATION','[[1,\"relation_type\",\"isys_relation_type__title\",\"LC__CATG__RELATION__RELATION_TYPE\",\"isys_cmdb_dao_category_g_relation::get_properties\",false,null,null],[1,\"weighting\",\"isys_weighting__title\",\"LC__CATG__RELATION__WEIGHTING\",\"isys_cmdb_dao_category_g_relation::get_properties\",false,null,null],[1,\"itservice\",false,\"LC__CMDB__CATG__IT_SERVICE\",\"isys_cmdb_dao_category_g_relation::get_properties\",[\"isys_cmdb_dao_category_g_relation\",\"dynamic_property_callback_itservice\"],null,null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__REPLICATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"replication_mechanism\",\"isys_replication_mechanism__title\",\"LC__CMDB__CATS__REPLICATION__MECHANISM\",\"isys_cmdb_dao_category_s_replication::get_properties\",false,\"LC__CATS__REPLICATION\",null],[1,\"replication_partner\",\"isys_connection__title\",\"LC__CATS__REPLICATION_PARTNER\",\"isys_cmdb_dao_category_s_replication_partner::get_properties\",false,\"LC__CATS__REPLICATION_PARTNER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__RM_CONTROLLER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ROOM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"number\",\"isys_cats_room_list__number\",\"LC__CMDB__CATS__ROOM_NUMBER\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"floor\",\"isys_cats_room_list__floor\",\"LC__CMDB__CATS__ROOM_FLOOR\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"type\",\"isys_room_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ROUTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"description\",\"isys_catg_sanpool_list__description\",\"LC__CMDB__LOGBOOK__DESCRIPTION\",\"isys_cmdb_dao_category_g_sanpool::get_properties\",false,\"LC__CMDB__CATG__LDEV_SERVER\",null],[1,\"lun\",\"isys_catg_sanpool_list__lun\",\"LUN\",\"isys_cmdb_dao_category_g_sanpool::get_properties\",false,\"LC__CMDB__CATG__LDEV_SERVER\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SAN_ZONING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"members\",\"isys_cats_san_zoning_list__id\",\"LC__CMDB__CATS__SAN_ZONING__MEMBERS\",\"isys_cmdb_dao_category_s_san_zoning::get_properties\",false,\"LC__CMDB__CATS__SAN_ZONING\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_service::get_properties\",false,\"LC__CMDB__CATS__SERVICE\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_service::get_properties\",false,\"LC__CMDB__CATS__SERVICE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SIM_CARD','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_cp_contract_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_g_sim::get_properties\",false,\"LC__CMDB__CATG__SIM\",null],[1,\"assigned_mobile\",\"isys_connection__title\",\"LC__CMDB__CATS__SIM_CARD__ASSIGNED_MOBILE_PHONE\",\"isys_cmdb_dao_category_g_cards::get_properties\",false,\"LC__CMDB__CATG__CARDS\",null],[1,\"network_provider\",\"isys_network_provider__title\",\"LC__CMDB__CATS_CP_CONTRACT__NETWORK_PROVIDER\",\"isys_cmdb_dao_category_g_sim::get_properties\",false,\"LC__CMDB__CATG__SIM\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__STACKING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SUPERNET','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_net_type__title\",\"LC__CMDB__CATS__NET__TYPE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_with_suffix\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_range\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_RANGE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"netmask\",\"isys_cats_net_list__mask\",\"LC__CMDB__CATS__NET__MASK\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SWITCH_CHASSIS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_chassis_slot_list__title\",\"LC__CMDB__CATG__GLOBAL_TITLE\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"assigned_devices\",\"isys_cats_chassis_slot_list__id\",\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__TELEPHONE_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__UPS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_ups_type__title\",\"LC__CMDB__CATS__UPS__TYPE\",\"isys_cmdb_dao_category_s_ups::get_properties\",false,\"LC__CMDB__OBJTYPE__UPS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VEHICLE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_CLIENT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_contact\",\"isys_connection__title\",\"LC__CATG__CONTACT_PRIMARY\",\"isys_cmdb_dao_category_g_contact::get_properties\",false,\"LC__CMDB__CATG__CONTACT\",null],[1,\"hosts\",\"vm_obj\",\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"primary\",\"isys_catg_virtual_machine_list__primary\",\"LC__CMDB__HOST_IN_CLUSTER\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"system\",\"isys_vm_type__title\",\"LC__CMDB__CATG__VIRTUALIZATION_SYSTEM\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_HOST','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"connected_object\",\"isys_catg_virtual_machine_list__isys_obj__id\",\"LC__CMDB__CATG__GUEST_SYSTEMS\",\"isys_cmdb_dao_category_g_guest_systems::get_properties\",false,\"LC__CMDB__CATG__GUEST_SYSTEMS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary\",\"isys_catg_virtual_machine_list__primary\",\"LC__CMDB__HOST_IN_CLUSTER\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"hosts\",\"vm_obj\",\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VOIP_PHONE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VRRP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"role\",\"isys_wan_role__title\",\"LC__CATG__WAN__ROLE\",\"isys_cmdb_dao_category_g_wan::get_properties\",false,\"LC__CATG__WAN\",null],[1,\"type\",\"isys_wan_type__title\",\"LC__CATG__WAN__TYPE\",\"isys_cmdb_dao_category_g_wan::get_properties\",false,\"LC__CATG__WAN\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WIRING_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_net_type_title__title\",\"LC__CMDB__CATS__WS_NET_TYPE\",\"isys_cmdb_dao_category_s_ws_net_type::get_properties\",false,\"LC__CMDB__CATS__WS_NET_TYPE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WORKSTATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"parent\",\"isys_catg_logical_unit_list__isys_obj__id__parent\",\"LC__CMDB__CATG__LOGICAL_UNIT__PARENT\",\"isys_cmdb_dao_category_g_logical_unit::get_properties\",false,\"LC__CMDB__CATG__LOGICAL_UNIT\",null],[1,\"assigned_object\",\"isys_obj__title\",\"LC_UNIVERSAL__OBJECT\",\"isys_cmdb_dao_category_g_assigned_logical_unit::get_properties\",false,\"LC__CMDB__CATG__ASSIGNED_LOGICAL_UNITS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__CMDB__OBJTYPE__CABLE_TRAY','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__CMDB__OBJTYPE__CONDUIT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJECT_TYPE__GROUP','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ACCESS_POINT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__ACCESS_POINT::ssid\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AIR_CONDITION_SYSTEM','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATS__AC::type\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AIRCRAFT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AMPLIFIER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__APPLIANCE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::all_ips\",\"C__CATG__IP::primary_hostname\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__APPLICATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__APPLICATION::manufacturer\",\"C__CATS__APPLICATION::installation_count\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BLADE_CHASSIS','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__CHASSIS_SLOT::title\",\"C__CATS__CHASSIS_SLOT::assigned_devices\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BLADE_SERVER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BUILDING','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__ADDRESS::street\",\"C__CATG__ADDRESS::postcode\",\"C__CATG__ADDRESS::city\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CABLE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CABLE::connection\",\"C__CATG__CABLE::cable_type\",\"C__CATG__CABLE::length\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CELL_PHONE_CONTRACT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__MODEL::serial\",\"C__CATS__CELL_PHONE_CONTRACT::imei_number\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CITY','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLIENT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CONTACT::primary_contact\",\"C__CATS__CLIENT::type\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CLUSTER::cluster_members\",\"C__CATG__CLUSTER::cluster_service\",\"C__CATG__CLUSTER::administration_service\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER_SERVICE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__CLUSTER_SERVICE::cluster\",\"C__CATS__CLUSTER_SERVICE::runs_on\",\"C__CATS__CLUSTER_SERVICE::type\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER_VRRP_HSRP','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CONVERTER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__COUNTRY','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DATABASE_INSTANCE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__DATABASE_INSTANCE::title\",\"C__CATS__DATABASE_INSTANCE::listener\",\"C__CATS__DATABASE_INSTANCE::instance\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DATABASE_SCHEMA','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__DATABASE_SCHEMA::storage_engine\",\"C__CATS__DATABASE_OBJECTS::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DBMS','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__APPLICATION::manufacturer\",\"C__CATS__APPLICATION::installation_count\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DISTRIBUTION_BOX','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__EMERGENCY_PLAN','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ENCLOSURE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__FORMFACTOR::rackunits\",\"C__CATG__LOCATION::location_path\",\"C__CATS__ENCLOSURE::vertical_slots_front\",\"C__CATS__ENCLOSURE::vertical_slots_rear\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__EPS','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ESC','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__POWER_SUPPLIER::volt\",\"C__CATG__POWER_SUPPLIER::watt\",\"C__CATG__POWER_SUPPLIER::ampere\",\"C__CATG__POWER_SUPPLIER::connector\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__FC_SWITCH','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CONTROLLER_FC_PORT::target\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__FILE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__HOST','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::all_ips\",\"C__CATG__IP::primary_hostname\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__IT_SERVICE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__ITS_TYPE::its_type\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__KRYPTO_CARD','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__KRYPTO_CARD::date_of_issue\",\"C__CATS__KRYPTO_CARD::certgate_card_number\",\"C__CATS__KRYPTO_CARD::imei_number\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__KVM_SWITCH','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LAYER2_NET','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__LAYER2_NET::vlan_id\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LAYER3_NET','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATS__NET_IP_ADDRESSES::ip_address_link\",\"C__CATS__NET::type\",\"C__CATS__NET::address_with_suffix\",\"C__CATS__NET::address_range\",\"C__CATS__NET::netmask\",\"C__CATS__NET::free_addresses\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LICENCE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__LICENCE_LIST::amount\",\"C__CATS__LICENCE_LIST::lic_not_in_use\",\"C__CATS__LICENCE_LIST::type\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MAINTENANCE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__CONTRACT::type\",\"C__CATS__CONTRACT::contract_status\",\"C__CATS__CONTRACT::run_time\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MIDDLEWARE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__APPLICATION::manufacturer\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MIGRATION_OBJECT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MONITOR','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_HOST_TPL','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_SERVICE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_SERVICE_TPL','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__OPERATING_SYSTEM','{\"advancedOptionMemoryUnit\":\"GB\",\"broadsearch\":false,\"filterProperty\":\"isys_cmdb_dao_category_g_global__title\",\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__OPERATING_SYSTEM::manufacturer\",\"C__CATS__OPERATING_SYSTEM::installation_count\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ORGANIZATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__ADDRESS::street\",\"C__CATG__ADDRESS::postcode\",\"C__CATG__ADDRESS::city\",\"C__CATS__ORGANIZATION_MASTER_DATA::telephone\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PARALLEL_RELATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__PARALLEL_RELATION::threshold\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PATCH_PANEL','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PDU','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CONNECTOR::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PERSON','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATS__PERSON_MASTER::last_name\",\"C__CATS__PERSON_MASTER::first_name\",\"C__CATS__PERSON_MASTER::department\",\"C__CATS__PERSON_MASTER::phone_company\",\"C__CATS__PERSON_MASTER::mail\",\"C__CATS__PERSON_LOGIN::title\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PERSON_GROUP','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__PERSON_GROUP_MASTER::email_address\",\"C__CATS__PERSON_GROUP_MASTER::phone\",\"C__CATS__PERSON_GROUP_MASTER::ldap_group\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PHONE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__TELEPHONE_FAX::extension\",\"C__CATG__TELEPHONE_FAX::telephone_number\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PRINTBOX','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PRINTER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATS__PRT::type\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__RELATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__RELATION::relation_type\",\"C__CATG__RELATION::weighting\",\"C__CATG__RELATION::itservice\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__REPLICATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__REPLICATION::replication_mechanism\",\"C__CATS__REPLICATION_PARTNER::replication_partner\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__RM_CONTROLLER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ROOM','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATS__ROOM::number\",\"C__CATS__ROOM::floor\",\"C__CATS__ROOM::type\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ROUTER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__IP::all_ips\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SAN','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LDEV_SERVER::description\",\"C__CATG__LDEV_SERVER::lun\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SAN_ZONING','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__SAN_ZONING::members\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SERVER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SERVICE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__SERVICE::manufacturer\",\"C__CATS__SERVICE::installation_count\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SIM_CARD','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__SIM::type\",\"C__CATG__CARDS::assigned_mobile\",\"C__CATG__SIM::network_provider\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__STACKING','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SUPERNET','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__NET::type\",\"C__CATS__NET::address_with_suffix\",\"C__CATS__NET::address_range\",\"C__CATS__NET::netmask\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SWITCH','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SWITCH_CHASSIS','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__CHASSIS_SLOT::title\",\"C__CATS__CHASSIS_SLOT::assigned_devices\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__TELEPHONE_SYSTEM','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__UPS','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATS__UPS::type\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VEHICLE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_CLIENT','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__CONTACT::primary_contact\",\"C__CATG__VIRTUAL_MACHINE::hosts\",\"C__CATG__VIRTUAL_MACHINE::primary\",\"C__CATG__VIRTUAL_MACHINE::system\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_HOST','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__GUEST_SYSTEMS::connected_object\",\"C__CATG__MODEL::manufacturer\",\"C__CATG__MODEL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_SERVER','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__IP::primary_hostaddress\",\"C__CATG__IP::primary_hostname\",\"C__CATG__VIRTUAL_MACHINE::primary\",\"C__CATG__VIRTUAL_MACHINE::hosts\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VOIP_PHONE','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VRRP','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::created\",\"C__CATG__GLOBAL::changed\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WAN','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__WAN::role\",\"C__CATG__WAN::type\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WIRING_SYSTEM','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATS__WS_NET_TYPE::title\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WORKSTATION','{\"advancedOptionMemoryUnit\":null,\"broadsearch\":false,\"filterProperty\":null,\"filterValue\":null,\"filterWildcard\":false,\"groupingType\":1,\"paging\":null,\"properties\":[\"C__CATG__GLOBAL::title\",\"C__CATG__LOGICAL_UNIT::parent\",\"C__CATG__ASSIGNED_LOGICAL_UNIT::assigned_object\",\"C__CATG__LOCATION::location_path\",\"C__CATG__GLOBAL::cmdb_status\"],\"rowClickable\":true,\"rowsPerPage\":null,\"showEmailLinks\":true,\"sortingDirection\":null,\"sortingProperty\":null}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.cable.change-cmdb-status-on-attach','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.cable.change-cmdb-status-on-detach','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.chassis.handle-location-changes','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.connector.suffix-schema','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.csv-export.remove-object-ids','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.gui.objectlist.direct-edit-mode','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.gui.remember-cmdb-status','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.cache-lifetime','86400',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.nmap-parameter','PE',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.ping-method','nmap',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.cmdb-explorer-service-browser','2500',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.connector-lists-assigned_connectors','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.obj-browser.objects-in-viewmode','8',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-lists-layer2','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-lists-vlans','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-overview-default-vlan-only','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-overview-vlans','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.lists.field-length-limit','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.logical-location.handle-location-inheritage','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.logical-location.object-type-filter','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.object-browser.max-objects','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.object.title.cable-prefix','KABEL_DEFAULT_',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.10.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.101.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.28.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.3.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.45.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.5.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.76.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.83.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.89.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.90.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.quickinfo.rows-per-category','15',0);
INSERT INTO `isys_settings` VALUES ('cmdb.quickpurge','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.rank-detached-segment-objects','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.segment-template-object-type','C__OBJTYPE__RACK_SEGMENT',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.slot-assignment-sort-direction','asc',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.vertical-slot-rear-mirrored','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.vertical-slot-sorting','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.refresh-table-configurations','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.lock_dataset','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.lock_timeout','120',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.mytask_entries','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.object_dragndrop','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.object_type_sorting','2',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.quicksave','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.sanitize_input_data','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.sysid_readonly','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.release-ip-on-archive-delete','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.renew-properties','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.sysid.prefix','SYSID_',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-distance','50',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-suggestion','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-threshold','0.2',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.color_value','CC0000',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.colors','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.show_assignments','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.status','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.hostname','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.ip-address','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.layer-2-net','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.object-title','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.validation.mac-address','0',0);
INSERT INTO `isys_settings` VALUES ('debug_bar.storeDirectory','/tmp/idoit_debugbar',0);
INSERT INTO `isys_settings` VALUES ('debug-bar.enabled','0',0);
INSERT INTO `isys_settings` VALUES ('defaults.search.mode','1',0);
INSERT INTO `isys_settings` VALUES ('email.template.maintenance','Your maintenance contract: %s timed out.\r\n\r\n<strong>Contract information</strong>:\r\nStart: %s\r\nEnd: %s\r\nSupport-Url: %s\r\nContract-Number: %s\r\nCustomer-Number: %s',0);
INSERT INTO `isys_settings` VALUES ('email.template.password','Ihr Passwort lautet:',0);
INSERT INTO `isys_settings` VALUES ('gui.empty_value','-',0);
INSERT INTO `isys_settings` VALUES ('gui.empty_values','-',0);
INSERT INTO `isys_settings` VALUES ('gui.forum-link','0',0);
INSERT INTO `isys_settings` VALUES ('gui.leftcontent.width','',0);
INSERT INTO `isys_settings` VALUES ('gui.lists.preload-pages','30',0);
INSERT INTO `isys_settings` VALUES ('gui.location_path.direction.rtl','0',0);
INSERT INTO `isys_settings` VALUES ('gui.separator.connector',' > ',0);
INSERT INTO `isys_settings` VALUES ('gui.separator.location',' > ',0);
INSERT INTO `isys_settings` VALUES ('gui.wiki-url','',0);
INSERT INTO `isys_settings` VALUES ('gui.wysiwyg','1',0);
INSERT INTO `isys_settings` VALUES ('gui.wysiwyg-all-controls','1',0);
INSERT INTO `isys_settings` VALUES ('idoit.notifications.license-expiration.skip-expired','0',0);
INSERT INTO `isys_settings` VALUES ('import.csv.import-limit','25',0);
INSERT INTO `isys_settings` VALUES ('import.csv.overwrite-objecttype','0',0);
INSERT INTO `isys_settings` VALUES ('import.hinventory.object-matching','1',0);
INSERT INTO `isys_settings` VALUES ('import.object.keep-status','0',0);
INSERT INTO `isys_settings` VALUES ('import.validation.break-on-error','1',0);
INSERT INTO `isys_settings` VALUES ('import.validation.empty-attribute-on-error','0',0);
INSERT INTO `isys_settings` VALUES ('jdisc.after_pause_action','cancel',0);
INSERT INTO `isys_settings` VALUES ('jdisc.max_pause_time_before_action','15',0);
INSERT INTO `isys_settings` VALUES ('jdisc.threshold','0',0);
INSERT INTO `isys_settings` VALUES ('jdisc.threshold_type','days',0);
INSERT INTO `isys_settings` VALUES ('key','value',0);
INSERT INTO `isys_settings` VALUES ('ldap.config','',0);
INSERT INTO `isys_settings` VALUES ('ldap.debug','1',0);
INSERT INTO `isys_settings` VALUES ('ldap.default-group','',0);
INSERT INTO `isys_settings` VALUES ('ldap.person.salutation.man','Herr, Mr., Mr',0);
INSERT INTO `isys_settings` VALUES ('ldap.person.salutation.woman','Frau, Mrs., Mrs, Ms., Ms, Miss',0);
INSERT INTO `isys_settings` VALUES ('logbook.changes','1',0);
INSERT INTO `isys_settings` VALUES ('logbook.delete-on-object-purge','0',0);
INSERT INTO `isys_settings` VALUES ('logging.cmdb.import','1',0);
INSERT INTO `isys_settings` VALUES ('logging.system.exceptions','0',0);
INSERT INTO `isys_settings` VALUES ('logging.user.last-login','0',0);
INSERT INTO `isys_settings` VALUES ('login.tenantlist.sortby','isys_mandator__sort',0);
INSERT INTO `isys_settings` VALUES ('maxlength.dialog_plus','110',0);
INSERT INTO `isys_settings` VALUES ('maxlength.location.objects','16',0);
INSERT INTO `isys_settings` VALUES ('maxlength.location.path','100',0);
INSERT INTO `isys_settings` VALUES ('minlength.login.password','4',0);
INSERT INTO `isys_settings` VALUES ('mysql.unbuffered-queries','0',0);
INSERT INTO `isys_settings` VALUES ('proxy.active','0',0);
INSERT INTO `isys_settings` VALUES ('proxy.host','',0);
INSERT INTO `isys_settings` VALUES ('proxy.password','',0);
INSERT INTO `isys_settings` VALUES ('proxy.port','',0);
INSERT INTO `isys_settings` VALUES ('proxy.username','',0);
INSERT INTO `isys_settings` VALUES ('qrcode.config','',0);
INSERT INTO `isys_settings` VALUES ('security.passwort.minlength','',0);
INSERT INTO `isys_settings` VALUES ('session.sso.active','0',0);
INSERT INTO `isys_settings` VALUES ('session.sso.mandator-id','1',0);
INSERT INTO `isys_settings` VALUES ('session.sso.use-domain-part','0',0);
INSERT INTO `isys_settings` VALUES ('session.time','3600',0);
INSERT INTO `isys_settings` VALUES ('system.csv-export-delimiter',';',0);
INSERT INTO `isys_settings` VALUES ('system.default-language','en',0);
INSERT INTO `isys_settings` VALUES ('system.devmode','',0);
INSERT INTO `isys_settings` VALUES ('system.email.connection-timeout','',0);
INSERT INTO `isys_settings` VALUES ('system.email.from','i-doit@example-domain.int',0);
INSERT INTO `isys_settings` VALUES ('system.email.name','',0);
INSERT INTO `isys_settings` VALUES ('system.email.password','',0);
INSERT INTO `isys_settings` VALUES ('system.email.port','',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtp-auto-tls','0',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtp-host','',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtpdebug','0',0);
INSERT INTO `isys_settings` VALUES ('system.email.subject-prefix','[i-doit] ',0);
INSERT INTO `isys_settings` VALUES ('system.email.username','',0);
INSERT INTO `isys_settings` VALUES ('system.last-change',UNIX_TIMESTAMP(),0);
INSERT INTO `isys_settings` VALUES ('system.login.welcome-message','',0);
INSERT INTO `isys_settings` VALUES ('system.security.csrf','1',0);
INSERT INTO `isys_settings` VALUES ('system.show-proc-time','0',0);
INSERT INTO `isys_settings` VALUES ('system.timezone','Europe/Berlin',0);
INSERT INTO `isys_settings` VALUES ('tts.rt.queues','',0);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `isys_reset_password_token` (
  `isys_reset_password_token__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_reset_password_token__token` varchar(255) NOT NULL,
  `isys_reset_password_token__user_id` int(10) unsigned NOT NULL,
  `isys_reset_password_token__tenant_id` int(10) unsigned NOT NULL,
  `isys_reset_password_token__created` datetime NOT NULL,
  `isys_reset_password_token__expires` datetime NOT NULL,
  PRIMARY KEY (`isys_reset_password_token__id`),
  CONSTRAINT `isys_reset_password_token__tenant_id` FOREIGN KEY (`isys_reset_password_token__tenant_id`) REFERENCES `isys_mandator` (`isys_mandator__id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
