<?php

/**
 * i-doit core classes
 *
 * @package     i-doit
 * @subpackage  Core
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
trait isys_settings_trait
{
    /** @var bool */
    protected static bool $isInitialized = false;

    /** @var array */
    protected static array $settings = [];

    /** @var bool */
    private static bool $hasChanged = false;

    /**
     * @return array
     */
    public static function get_definition(): array
    {
        return self::$definition;
    }

    /**
     * @return array
     */
    public static function getRawDefinition(): array
    {
        $definitions = [];
        $settingDefinitions = self::get_definition();

        foreach ($settingDefinitions as $definition) {
            $definitions = array_merge($definitions, $definition);
        }

        return $definitions;
    }

    /**
     * @param array $settings
     *
     * @return void
     */
    public static function extend(array $settings = []): void
    {
        self::$definition = array_merge_recursive(self::$definition, $settings);
    }

    /**
     * @return bool
     * @deprecated This is an empty alias for compatibility.
     */
    public static function is_initialized(): bool
    {
        return true;
    }

    /**
     * @return void
     * @deprecated This is an empty alias for compatibility.
     */
    public static function load_cache(string $cacheDirectory): void
    {
    }

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return void
     */
    public static function set(string $key, mixed $value): void
    {
        self::$hasChanged = true;

        if (!isset(self::$settings[$key])) {
            self::$dao->set($key, $value)
                ->apply_update();
        }

        self::$settings[$key] = $value;
    }

    /**
     * @param string $key
     *
     * @return void
     * @throws isys_exception_dao
     */
    public static function remove(string $key): void
    {
        unset(self::$settings[$key]);

        self::$dao->remove($key);
    }

    /**
     * @param string|null $key
     * @param mixed       $default
     *
     * @return mixed
     */
    public static function get(string|null $key = null, mixed $default = ''): mixed
    {
        if ($key === null) {
            return self::$settings;
        }

        return isset(self::$settings[$key]) && self::$settings[$key] !== '' ? self::$settings[$key] : $default;
    }

    /**
     * @param string $key
     *
     * @return bool
     */
    public static function has(string $key): bool
    {
        return isset(self::$settings[$key]);
    }

    /**
     * @return void
     * @deprecated This is an empty alias for compatibility.
     */
    public static function override(array $settings): void
    {
    }

    /**
     * @return void
     */
    public static function force_save(): void
    {
        // Save to database.
        self::$dao->save(self::$settings);
    }

    /**
     * Before destructing the usersettings we want to save the data.
     */
    public static function shutdown()
    {
        if (self::$hasChanged) {
            self::force_save();
        }
    }
}
