<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Certificate
 * A certificate installed on an operating systems's certificate store. */
final class CertificateType implements AutoGenerationInterface, BaseCertificateInfoInterface
{
    /**
     * The certificate issuer
     */
    public ?string $issuer = null;
    /**
     * The certificate key size
     */
    public ?int $keyLength = null;
    /**
     * The certificate signature algorithm
     */
    public ?PublicKeyEncryptionTypeEnum $keyType = null;
    /**
     * The certificate key usage(s)
     * @var null|iterable|CertificateKeyUsageEnum[]
     */
    public ?iterable $keyUsage = null;
    /**
     * The certificate end date
     */
    public $notAfter = null;
    /**
     * The certificate start date
     */
    public $notBefore = null;
    /**
     * The certificate OID
     */
    public ?string $oid = null;
    /**
     * The certificate serial number
     */
    public ?string $serialNumber = null;
    /**
     * The certificate subject
     */
    public ?string $subject = null;
    /**
     * The certificate thumbprint (fingerprint)
     */
    public ?string $thumbprint = null;
    /**
     * The certificate version (expected value is always 3 since X509 v3 supported only)
     */
    public ?string $version = null;
    /**
     * The list of extended key usage OIDs
     * @var null|iterable|string[]
     */
    public ?iterable $extendedKeyUsage = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The list of installations for this certificate
     * @var null|iterable
     */
    public ?iterable $installations = null;
    /**
     * The list of subject alternative names for this certificate
     * @var null|iterable|string[]
     */
    public ?iterable $subjectAlternativeNames = null;
}