<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ChartLegendOptionsInput
 * The chart legend options * @property null|ChartLeftOptionEnum $left = null Distance between legend component and the left side of the container. left value can be instant pixel value like 20; it can also be a percentage value relative to container width like '20%'; and it can also be 'left', 'center', or 'right'. If the left value is set to be 'left', 'center', or 'right', then the component will be aligned automatically based on position.
 * @property null|ChartOrientOptionEnum $orient = null The layout orientation of legend. Options: horizontal or vertical
 * @property null|bool $show = null Set this false to prevent the legend from showing
 * @property null|ChartTopOptionEnum $top = null Distance between legend component and the top side of the container. top value can be instant pixel value like 20; it can also be a percentage value relative to container width like '20%'; and it can also be 'top', 'middle', or 'bottom'. If the top value is set to be 'top', 'middle', or 'bottom', then the component will be aligned automatically based on position.
 */
final class ChartLegendOptionsInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'left') {
            return new ChartLeftOptionEnum($value);
        }

        if ($name === 'orient') {
            return new ChartOrientOptionEnum($value);
        }

        if ($name === 'top') {
            return new ChartTopOptionEnum($value);
        }

        return $value;
    }
}