<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DeviceGroup
 * A device group can be used to group devices by different aspects (network membership, basic device properties etc.). */
final class DeviceGroupType implements AutoGenerationInterface
{
    /**
     * A flag whether to also assign directly attached devices of group members to the group (e.g. attached monitors)
     */
    public ?bool $assignDirectlyAttachedDevices = null;
    /**
     * The child directories.
     * @var null|iterable
     */
    public ?iterable $children = null;
    /**
     * The device group's description.
     */
    public ?string $description = null;
    /**
     * Returns the list of devices assigned to the group. Note that the root group has implicitly all devices assigned to it. Therefore, the root group will always return an empty set of devices (this is a JPA limitation which we might find a workaround in future versions)
     * @var null|iterable
     */
    public ?iterable $devices = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The device group's name.
     */
    public ?string $name = null;
    /**
     * The parent device group.
     */
    public ?DeviceGroupType $parentDeviceGroup = null;
    /**
     * A flag whether to use strict credentials usage for this group. The discovery does not use default accounts from other groups if a device belongs to this group!
     */
    public ?bool $strictPasswordUsage = null;
    /**
     * The device group's type.
     */
    public ?DeviceGroupTypeEnum $type = null;
    /**
     * A flag whether to use the default accounts from all Unix platforms for unknown devices.
     */
    public ?bool $useDefaultAccountsForUnknown = null;
    /**
     * Gets the list of directory items that make up this definition
     * @var null|iterable
     */
    public ?iterable $definingDirectoryItems = null;
    /**
     * Gets the list of IP4 networks that make up this definition
     * @var null|iterable
     */
    public ?iterable $definingIP4Networks = null;
    /**
     * Gets the list of IP6 networks that make up this definition
     * @var null|iterable
     */
    public ?iterable $definingIP6Networks = null;
    /**
     * Gets the list of network neighborhoods (domains or workgroups) that make up this definition
     * @var null|iterable
     */
    public ?iterable $definingNetworkNeighborhoods = null;
    /**
     * Flag whether the device group is the root group.
     */
    public bool $isRoot;
}