<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type InstalledApplicationInput
 * An application installed on an operating system. * @property null|ApplicationInputInputType $application = null The associated application
 * @property mixed $installationDate = null The application installation timestamp
 * @property null|string $installationPath = null The application installation path
 * @property null|bool $isClickToRun = null A flag whether the application is installed as a Microsoft click to run application
 * @property null|LicenseInputInputType $license = null The associated license
 * @property null|OperatingSystemInputInputType $operatingSystem = null The operating system the software is installed on
 * @property null|ApplicationSourceEnum $source = null The source where we got the application information from (e.g. Add/Remove Programs, rpm, dpkg, ...)
 */
final class InstalledApplicationInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'application') {
            return new ApplicationInputInputType($value);
        }

        if ($name === 'license') {
            return new LicenseInputInputType($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'source') {
            return new ApplicationSourceEnum($value);
        }

        return $value;
    }
}