<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type KubernetesDeploymentInput
 * A kubernetes deployment. * @property null|ClusterInputInputType $cluster = null The cluster that this daemon set is assigned to.
 * @property null|string $name = null The kubernetes service name.
 * @property null|KubernetesNamespaceInputInputType $namespace = null The namespace that this deployment is assigned to.
 * @property null|iterable|DeviceInputInputType[] $pods = null The pods associated with this deployment.
 * @property null|iterable|KubernetesReplicaSetInputInputType[] $replicaSets = null The replica sets for this deployment.
 * @property null|string $uniqueId = null A kubernetes service's unique id.
 */
final class KubernetesDeploymentInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'cluster') {
            return new ClusterInputInputType($value);
        }

        if ($name === 'namespace') {
            return new KubernetesNamespaceInputInputType($value);
        }

        if ($name === 'pods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'replicaSets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesReplicaSetInputInputType($v)); })($value);
        }

        return $value;
    }
}