<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type ScheduledTask
 * A scheduled task defined for a device */
final class ScheduledTaskType implements AutoGenerationInterface
{
    /**
     * The scheduled task author.
     */
    public ?string $author = null;
    /**
     * The list of scheduled task Microsoft COM handler actions.
     * @var null|iterable
     */
    public ?iterable $comHandlerActions = null;
    /**
     * The scheduled task description.
     */
    public ?string $description = null;
    /**
     * The device to which this scheduled task belongs to.
     */
    public ?DeviceType $device = null;
    /**
     * The list of scheduled task email actions.
     * @var null|iterable
     */
    public ?iterable $emailActions = null;
    /**
     * Flag whether the scheduled task is enabled.
     */
    public ?bool $enabled = null;
    /**
     * The list of scheduled task execute actions.
     * @var null|iterable
     */
    public ?iterable $executeActions = null;
    /**
     * Flag whether the scheduled task is hidden.
     */
    public ?bool $hidden = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The last duration in milliseconds (only available when  scheduled task operation event logging enabled on the device)
     */
    public $lastDuration = null;
    /**
     * The timestamp when the task has been executed for the last time.
     */
    public $lastExecutedTime = null;
    /**
     * The scheduled task logon type.
     */
    public ?DeviceScheduledTaskLogonTypeEnum $logonType = null;
    /**
     * The list of scheduled task email actions.
     * @var null|iterable
     */
    public ?iterable $messageActions = null;
    /**
     * The scheduled task registration date.
     */
    public $registrationDate = null;
    /**
     * The scheduled task logon type.
     */
    public ?DeviceScheduledTaskRunLevelTypeEnum $runlevel = null;
    /**
     * The list of scheduled task triggers.
     * @var null|iterable
     */
    public ?iterable $triggers = null;
    /**
     * The URI for the scheduled task.
     */
    public ?string $uri = null;
    /**
     * The last execution result.
     */
    public ?string $lastExecutionResult = null;
    /**
     * The user which this task runs as.
     */
    public ?string $runUser = null;
    /**
     * The user group which this task runs as.
     */
    public ?string $runUserGroup = null;
}