<div class="m20 p20 box-purple">
    <h2>[{isys type="lang" ident="LC__SYNETICS_ADMIN__ADVERTISE_SUBSCRIPTION_AND_ADDONS"}]</h2>
    <a class="btn mt20" href="[{$g_link__administration}]">
        <img src="[{isys_application::instance()->www_path}]src/classes/modules/synetics_admin/templates/img/subscription-and-add-ons.svg" alt="" />
        <span>[{isys type="lang" ident="LC__SYNETICS_ADMIN"}]</span>
    </a>
</div>

<div class="contract-center-container">
    <table class="contentTable">
        <tr>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_NO"}]</td>
            <td class="value">[{$contract.name}]</td>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_START_DATE"}]</td>
            <td class="value">[{$contract.startDate}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_TYPE"}]</td>
            <td class="value">[{$contract.type}]</td>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__SUBSCRIPTION_END_DATE"}]</td>
            <td class="value">[{$contract.subscriptionEndDate}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_STATUS"}]</td>
            <td class="value">[{$contract.status}]</td>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__SUBSCRIPTION_TERM"}]</td>
            <td class="value">
                [{$contract.contractTerm}]
                [{if $contract.contractTerm == 1}]
                    [{isys type="lang" ident="LC__UNIVERSAL__MONTH"}]
                [{else}]
                    [{isys type="lang" ident="LC__UNIVERSAL__MONTHS"}]
                [{/if}]
            </td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_AUTO_RENEW"}]</td>
            <td class="value">
                [{if $contract.autoRenew}]
                [{isys type="lang" ident="LC__UNIVERSAL__YES"}]
                [{else}]
                [{isys type="lang" ident="LC__UNIVERSAL__NO"}]
                [{/if}]
            </td>
            <td class="key">[{isys type="lang" ident="LC__CONTRACT_CENTER__CONTRACT_END_DATE"}]</td>
            <td class="value">[{$contract.endDate}]</td>
        </tr>
    </table>

    <h1 class="m20">[{isys type="lang" ident="LC__CONTRACT_CENTER__ACTIVE_PRODUCTS"}]</h1>

    <div class="p20">
        <div class="box-blue p10 display-flex align-items-center">
            <img src="[{$dir_images}]axialis/basic/button-info.svg" class="mr5" alt="" />
            <p>[{isys type="lang" ident="LC__CONTRACT_CENTER__FREE_DOWNLOAD_INFO"}]</p>
            <a href="[{$downloadCenterUrl}]" target="_blank" class="ml10 btn btn-small" style="flex-shrink: 0">
                <img src="[{$dir_images}]axialis/basic/symbol-download.svg" alt="" />
                <span>[{isys type="lang" ident="LC__DOWNLOAD_CENTER"}]</span>
            </a>
        </div>

        <table class="mainTable">
            <thead>
            <tr>
                <th>[{isys type="lang" ident="LC__CONTRACT_CENTER__ASSET__ASSET_NAME"}]</th>
                <th>[{isys type="lang" ident="LC__CONTRACT_CENTER__ASSET__ASSET_TYPE"}]</th>
                <th>[{isys type="lang" ident="LC__CONTRACT_CENTER__ASSET__QUANTITY"}]</th>
            </tr>
            </thead>
            <tbody>
            [{foreach $contract.assets as $asset}]
                <tr>
                    <td>[{$asset.name}]</td>
                    <td>[{$asset.typeLabel}]</td>
                    <td>[{$asset.quantity}]</td>
                </tr>
                [{/foreach}]
            </tbody>
        </table>
    </div>
</div>

<script>
    (() => {
        // Navbar buttons can currently not be created as links with target="_blank".
        $('navbar_item_contract-center-installation')
            .writeAttribute('onclick', '')
            .on('click', () => window.open('[{isys type="lang" ident="LC__CONTRACT_CENTER__INSTALLATION_INSTRUCTIONS_URL"}]', '_blank').focus());

        $('navbar_item_contract-center-activation')
            .writeAttribute('onclick', '')
            .on('click', () => window.open('[{isys type="lang" ident="LC__CONTRACT_CENTER__ACTIVATION_INSTRUCTIONS_URL"}]', '_blank').focus());

        $('navbar_item_contract-center-contact-us')
            .writeAttribute('onclick', '')
            .on('click', () => {
                new Ajax.Request('[{$contactUsModalUrl}]', {
                    method: 'GET',
                    onComplete: (xhr) => { Modal.open(xhr.responseText, { maxWidth: 400, maxHeight: 300 }); }
                });
            });
    })();
</script>

<style>
    [{include file=$cssPath}]
</style>
