<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Cluster
 * A cluster object. */
final class ClusterType implements AutoGenerationInterface
{
    /**
     * A flag whether all cluster members have been found.
     */
    public ?bool $allMembersFound = null;
    /**
     * The associated cluster member virtual machines.
Note, that this is not the list of VMs running in this cluster.
It is more a configuration item in some virtualization environments (e.g. XenServer). You can associate a VM with a cluster
and then the cluster decides on which physical host of the cluster the VM gets started.
     * @var null|iterable
     */
    public ?iterable $associatedVirtualMachines = null;
    /**
     * The cluster member devices
     * @var null|iterable
     */
    public ?iterable $clusterMembers = null;
    /**
     * The internal id for this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The Kubernetes daemon sets that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesDaemonSets = null;
    /**
     * The Kubernetes deployments that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesDeployments = null;
    /**
     * The Kubernetes namespaces that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesNamespaces = null;
    /**
     * The Kubernetes pods that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesPods = null;
    /**
     * The Kubernetes replica sets that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesReplicaSets = null;
    /**
     * The Kubernetes services that belong to this cluster when the cluster is a Kubernetes cluster
     * @var null|iterable
     */
    public ?iterable $kubernetesServices = null;
    /**
     * The cluster's name.
     */
    public ?string $name = null;
    /**
     * The cluster type
     */
    public ?ClusterTypeEnum $type = null;
    /**
     * The cluster's unique id.
     */
    public ?string $uniqueId = null;
    /**
     * The virtual datacenter that a cluster belongs to.
     */
    public ?VirtualDatacenterType $virtualDatacenter = null;
}