<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DeviceCredentialManagement
 */
final class DeviceCredentialManagementType implements AutoGenerationInterface
{
    /**
     * Update/Delete account information to be used by discovery for the given devices

Required permissions: ManageDevices
     * @var null|iterable
     */
    public ?iterable $batchUpdateAccounts = null;
    /**
     * Update/Delete account information to be used by discovery for the given devices (Async)

Required permissions: ManageDevices
     */
    public ?DeviceAccountsUpdateOperationResultType $batchUpdateAccountsAsync = null;
    /**
     * Reset all cached credentials for the given devices.

Required permissions: ManageDevices
     */
    public bool $clearCachedCredentials;
    /**
     * Reset all cached credentials (async). Returns a progress info object to monitor the progress.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $clearCachedCredentialsAsync = null;
    /**
     * Set account information to discover the given devices. Returns a list of devices that could not be found or an empty list if succesfull.

Required permissions: ManageDevices
     * @deprecation Pending removal
     * @var null|iterable
     */
    public ?iterable $setAccounts = null;
    /**
     * Set account information to discover the given devices. Returns a list of devices that could not be found or an empty list if succeeded.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $setAccountsAsync = null;
    /**
     * Set database account information to discover the given device. Returns <true> if succeeded.

Required permissions: ManageDevices
     */
    public bool $setDatabaseAccount;
    /**
     * Set HTTP account information to discover the given devices. Returns a list of devices that could not be found or an empty list if succeeded.

Required permissions: ManageDevices
     * @deprecation No longer supported
     * @var null|iterable
     */
    public ?iterable $setHttpAccounts = null;
    /**
     * Set HTTP accounts to the given devices. Returns a progress info object to monitor the progress.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $setHttpAccountsAsync = null;
    /**
     * Set SNMP account information to discover the given devices. Returns a list of devices that could not be found or an empty list if succeeded.

Required permissions: ManageDevices
     * @deprecation No longer supported
     * @var null|iterable
     */
    public ?iterable $setSnmpAccounts = null;
    /**
     * Set SNMP account information to discover the given devices async. Returns a progress info object to monitor the progress.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $setSnmpAccountsAsync = null;
    /**
     * Set account information to discover the given devices. Returns a list of devices that could not be found or an empty list if succeeded.

Required permissions: ManageDevices
     * @var null|iterable
     */
    public ?iterable $setSshAccounts = null;
    /**
     * Set vmware accounts to the given devices. Returns a list of devices that could not be found or an empty list if succeeded.

Required permissions: ManageDevices
     * @deprecation No longer supported
     * @var null|iterable
     */
    public ?iterable $setVMwareAccounts = null;
    /**
     * Set vmware accounts to the given devices. Returns a progress info object to monitor the progress.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $setVMwareAccountsAsync = null;
    /**
     * Update/Delete account information to be used by discovery for the given device

Required permissions: ManageDevices
     */
    public ?bool $updateAccounts = null;
}