<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DiscoveryDeviceQueueItemInput
 * A device queue item. * @property null|DiscoveryJobInputInputType $discoveryJob = null The corresponding discovery job when the discovery was triggered by a discovery job. Otherwise null
 * @property null|string $hostname = null The device's hostname in case the hostname was added and not an IP address.
 * @property null|bool $ignoreFilters = null Should the discovery for this item ignore filters?
 * @property null|DiscoveryQueuePriorityEnum $priority = null The queue item priority. Items with a higher priority get scanned earlier.
 * @property null|DiscoveryQueueSourceEnum $source = null The queue status.
 * @property null|DiscoveryQueueItemStatusEnum $status = null The queue item status.
 * @property null|string $ipAddress = null The IP address (either IP4 or IP6). For now it is returning string but might change in the future.
 */
final class DiscoveryDeviceQueueItemInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'discoveryJob') {
            return new DiscoveryJobInputInputType($value);
        }

        if ($name === 'priority') {
            return new DiscoveryQueuePriorityEnum($value);
        }

        if ($name === 'source') {
            return new DiscoveryQueueSourceEnum($value);
        }

        if ($name === 'status') {
            return new DiscoveryQueueItemStatusEnum($value);
        }

        return $value;
    }
}