<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type KubernetesNamespaceInput
 * A namespace in a kubernetes cluster. * @property null|ClusterInputInputType $cluster = null The cluster that this daemon set is assigned to.
 * @property null|iterable|KubernetesDaemonSetInputInputType[] $daemonSets = null The daemon sets for this namespace
 * @property null|iterable|KubernetesDeploymentInputInputType[] $deployments = null The services belonging to this namespace
 * @property null|string $name = null The namespace name.
 * @property null|iterable|DeviceInputInputType[] $pods = null The pods belonging to this namespace
 * @property null|iterable|KubernetesReplicaSetInputInputType[] $replicaSets = null The replica sets for this namespace
 * @property null|string $uniqueId = null A namespace's unique id.
 */
final class KubernetesNamespaceInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'cluster') {
            return new ClusterInputInputType($value);
        }

        if ($name === 'daemonSets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesDaemonSetInputInputType($v)); })($value);
        }

        if ($name === 'deployments') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesDeploymentInputInputType($v)); })($value);
        }

        if ($name === 'pods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'replicaSets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesReplicaSetInputInputType($v)); })($value);
        }

        return $value;
    }
}