<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type PortConnectionInput
 * The port connection object is used to store
- an open TCP/IP or UDP port
- a TCP/IP connection between two processes on the same or different device

The connectionState defines whether the port is listening or whether it is a TCP/IP connection. * @property mixed $discoveryTime = null The time when this connection/open port has been scanned for the last time.
 * @property null|string $sslCipher = null The cipher used for the SSL connection
 * @property null|string $sslProtocol = null The protocol for the SSL connection (e.g. TLS 1.2, TLS 1.3)
 * @property null|TcpConnectionStateEnum $state = null The connection state.
 * @property null|PortConnectionTypeEnum $type = null The connection state.
 * @property null|string $sourceAddress = null The IP address that is used by the initiating process to establish this connection.
 * @property null|DeviceInputInputType $sourceDevice = null The device that hosts the source of the TCP/IP connection.
 * @property null|string $sourcePortDescription = null The description for a connection's source port.
 * @property null|string $sourcePortName = null The name for a connection's source port.
 * @property null|int $sourcePortNumber = null The source port that is used by the initiating process to establish this connection or listen on this port.
 * @property null|ProcessInputInputType $sourceProcess = null The process that initiated the TCP/IP connection.
 * @property null|string $targetAddress = null The target IP address that this connection connects to.
 * @property null|DeviceInputInputType $targetDevice = null The process that hosts the target of the TCP/IP connection.
 * @property null|string $targetPortDescription = null The description for a connection's target port.
 * @property null|string $targetPortName = null The name for a connection's target port.
 * @property null|int $targetPortNumber = null The target port for this TCP/IP connection.
 * @property null|ProcessInputInputType $targetProcess = null The process that is the target of the TCP/IP connection.
 */
final class PortConnectionInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'state') {
            return new TcpConnectionStateEnum($value);
        }

        if ($name === 'type') {
            return new PortConnectionTypeEnum($value);
        }

        if ($name === 'sourceDevice') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'sourceProcess') {
            return new ProcessInputInputType($value);
        }

        if ($name === 'targetDevice') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'targetProcess') {
            return new ProcessInputInputType($value);
        }

        return $value;
    }
}