<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ReportNetworkExportJobInput
 * A report network export job configuration * @property null|string $baseFileName = null The job's export format baseFileName attribute
 * @property null|BuiltInReportEnum $builtInReport = null The job's connected report name
 * @property mixed $creationTime = null The entity's creation time.
 * @property mixed $customReportId = null The job's connected custom report id
 * @property null|TextFileEncodingEnum $encoding = null The job's export format encoding attribute
 * @property null|ExportFormatEnum $exportFormat = null The job's export format
 * @property null|ExportTypeEnum $exportType = null The job's export type
 * @property null|bool $filterCaseSensitive = null The job's filter case-sensitive flag
 * @property null|string $filterValue = null The job's filter value
 * @property null|string $id = null The internal id of network export job.
Mandatory for change and delete operations.
Note that the id might change when the entity gets deleted and recreated.
 * @property null|InventoryUserInputInputType $inventoryUser = null The job's owner
 * @property null|bool $invertFilter = null The job's invert filter flag
 * @property mixed $modificationTime = null The entity's modification time.
 * @property null|string $name = null The job's name
 * @property null|NetworkStorageLocationInputInputType $networkStorageLocation = null The job's export storage location
 * @property null|string $nullValue = null The job's export format nullValue attribute
 * @property null|int $numberOfHistoryFiles = null The job's export numberOfHistoryFiles attribute
 * @property null|bool $overwriteExistingFile = null The job's export overwriteExistingFile attribute
 * @property null|string $reportTitle = null The job's connected report title
 * @property null|string $separator = null The job's export format separator attribute
 * @property null|string $sortByColumn = null The job's sort column configuration
 * @property null|SortOrderEnum $sortOrder = null The job's sort order configuration
 * @property null|bool $useHumanReadableDateDurationOutput = null The job's export format useHumanReadableDateDurationOutput attribute
 * @property null|bool $useHumanReadableOutput = null The job's export format useHumanReadableOutput attribute
 * @property null|bool $useMultipleLines = null The job's export format useMultipleLines attribute
 * @property null|ScheduleInputInputType $schedule = null The job's schedule
 * @property null|string $inventoryUserLogin = null The job's owner login
 */
final class ReportNetworkExportJobInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'builtInReport') {
            return new BuiltInReportEnum($value);
        }

        if ($name === 'encoding') {
            return new TextFileEncodingEnum($value);
        }

        if ($name === 'exportFormat') {
            return new ExportFormatEnum($value);
        }

        if ($name === 'exportType') {
            return new ExportTypeEnum($value);
        }

        if ($name === 'inventoryUser') {
            return new InventoryUserInputInputType($value);
        }

        if ($name === 'networkStorageLocation') {
            return new NetworkStorageLocationInputInputType($value);
        }

        if ($name === 'sortOrder') {
            return new SortOrderEnum($value);
        }

        if ($name === 'schedule') {
            return new ScheduleInputInputType($value);
        }

        return $value;
    }
}