<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ThycoticSecretServerInput
 * This object contains information about the Delinea secret server. * @property null|iterable|ThycoticFolderInputInputType[] $folders = null The list of folders
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|bool $isCloudServer = null A flag that indicates whether the Delinea server is hosted in the cloud.
 * @property null|string $name = null The server's descriptive name as provided by the user.
 * @property null|string $password = null The account's password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
 * @property null|int $port = null The port that the server is listening on.
 * @property null|bool $searchByHostname = null Search by the hostname only when searching for a device account. Note that a hostname might be not unique within different domains!
 * @property null|string $serverAddress = null The server's address (IP address or hostname).
 * @property null|PasswordManagementStatusInputInputType $status = null The server status
 * @property null|bool $useDeviceAccounts = null A flag whether the secret server should be used to get accounts for individual devices based on IP or hostname.
 * @property null|string $username = null The username used to authenticate against the Delinea server..
 * @property null|string $label = null The server label
 */
final class ThycoticSecretServerInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'folders') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ThycoticFolderInputInputType($v)); })($value);
        }

        if ($name === 'status') {
            return new PasswordManagementStatusInputInputType($value);
        }

        return $value;
    }
}