<?php

/**
 * i-doit
 *
 * Popup class for category folders feature.
 *
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_category_folders_create extends isys_component_popup
{
    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template & $p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        $l_button_options = [
            'id'                => $p_params['name'],
            'icon'              => isys_application::instance()->www_path . 'images/axialis/basic/symbol-add.svg',
            'p_bInfoIconSpacer' => 0,
            'p_onClick'         => $this->getModalJs('', 550, 300, [], 550, 300, 'configuration'),
            'type'              => 'button',
            'p_strValue'        => $this->language->get('LC__CATEGORY_FOLDERS__ADD'),
            'p_strClass'        => 'ml10',
            'p_bDisabled'       => true
        ];

        return (new isys_smarty_plugin_f_button())->navigation_edit($this->template, $l_button_options);
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request     $p_modreq
     *
     * @return void
     * @throws \idoit\Exception\JsonException
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        // Unpack popup request.
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));
        $configurationId = (int)$parameters['configId'];
        $preselectionParentId = (int)$parameters['parent'];

        $l_rules = [
            'C__CATEGORY_FOLDERS__FOLDER_NAME'     => [
                'p_strClass' => 'input-small'
            ],
            'C__CATEGORY_FOLDERS__FOLDER_LOCATION' => [
                'p_strPopupType'    => 'category_folders_selection',
                'disableInputGroup' => 'true',
                'configId'          => $configurationId,
                'folderId'          => $preselectionParentId > 0 ? $preselectionParentId : null
            ]
        ];

        // Display the dialog template and return it.
        $this->template
            ->activate_editmode()
            ->assign('popupHeadline', 'LC__CATEGORY_FOLDERS__ADD_FOLDER')
            ->assign('folderUrl', isys_application::instance()->container->get('route_generator')->generate('pro.category-folders.edit-folder'))
            ->assign('configId', $configurationId)
            ->smarty_tom_add_rules('tom.popup.category-folders.create-folder', $l_rules)
            ->display(dirname(__DIR__) . '/templates/SettingPage/CategoryFolders/popup/update-folder.tpl');
        die;
    }
}
