[{isys_group name="tom.popup.visualization"}]
    <div id="visualization-popup">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICE_SELECTION"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>

        <div class="popup-content">
            <table class="w100 h100" style="table-layout: fixed">
                <tr>
                    <td class="vat" style="width:240px;">
                        <h2 class="p5 mb10">[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICE_TYPES"}]</h2>

                        <ul id="C_VISUALIZATION_ITS_TYPES" class="list-style-none m0 pr20">
                            [{foreach $it_service_types as $it_service_type_id => $it_service_type_title}]
                                <li>
                                    <label>
                                        <input type="radio" name="C_VISUALIZATION_ITS_TYPE_SELECTION" value="[{$it_service_type_id}]" class="ml5 mr5" />
                                        <span>[{$it_service_type_title}]</span>
                                    </label>
                                </li>
                            [{/foreach}]
                        </ul>
                    </td>
                    <td class="vat">
                        <h2 class="p5 mb10">
                            [{isys type="f_text" name="C_VISUALIZATION_ITS_SEARCH" p_strClass="input input-small fr vam" p_bInfoIconSpacer=0 p_strPlaceholder="LC__PROPERTY_SELECTOR__SEARCH_IN_PROPERTIES" disableInputGroup=true}]
                            [{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICES"}]
                        </h2>

                        <div id="C_VISUALIZATION_ITS_CONTAINER">
                            <!-- To be filled by AJAX -->
                        </div>
                    </td>
                </tr>
            </table>
        </div>

        <div class="popup-footer-ng">
            <button type="button" class="btn popup-closer">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__CLOSE_POPUP"}]</span>
            </button>
        </div>
    </div>
    <script type="text/javascript">
        (function () {
            'use strict';

            var $popup                  = $('visualization-popup'),
                $search                 = $('C_VISUALIZATION_ITS_SEARCH'),
                $itserviceTypeContainer = $('C_VISUALIZATION_ITS_TYPES'),
                $itserviceListContainer = $('C_VISUALIZATION_ITS_CONTAINER'),
                itsFilterTmp            = '';

            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $search.on('keypress', function (event) {
                var itsFilter = $search.getValue().trim();

                // Prevent form submission
                if (event.keyCode == 13) {
                    delay(function () {
                        itsFilterTmp = itsFilter;

                        $itserviceListContainer.fire('reload:list');
                    }, 500, 'its.keypress');

                    event.preventDefault();
                }

                if (itsFilterTmp != itsFilter && (itsFilter.length === 0 || itsFilter.length >= 3)) {
                    delay(function () {
                        itsFilterTmp = itsFilter;

                        $itserviceListContainer.fire('reload:list');
                    }, 500, 'its.keypress');
                }
            });

            $itserviceTypeContainer.on('change', 'input', function (ev) {
                $itserviceTypeContainer.select('li').invoke('removeClassName', 'active');

                ev.findElement('li').addClassName('active')

                $search.setValue('');
                $itserviceListContainer.fire('reload:list');
            });

            $itserviceListContainer.on('reload:list', function () {
                var itsFilter = $search.getValue().trim();

                if (itsFilter.length < 3) {
                    itsFilter = '';
                }

                $itserviceListContainer.update(new Element('div', {className: 'm5'})
                    .update(new Element('img', { src: window.dir_images + 'axialis/user-interface/loading.svg', className: 'vam mr5 animation-rotate' }))
                    .insert(new Element('span', { className: 'vam' }).update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]')));

                // Reloads the second chosen field.
                new Ajax.Request('[{$ajax_url}]', {
                    parameters: {
                        type:   $itserviceTypeContainer.down('input:checked').getValue().toLowerCase(),
                        filter: itsFilter
                    },
                    onComplete: function (response) {
                        var json = response.responseJSON, i, $ul = new Element('ul', {className: 'list-style-none m0'});

                        if (!is_json_response(response, true)) {
                            return;
                        }

                        if (json.success) {
                            if (json.data.length === 0) {
                                $itserviceListContainer
                                    .update(new Element('div', {className: 'p5 m5 box-blue'})
                                        .update(new Element('img', { src: window.dir_images + 'axialis/basic/button-info.svg', className: 'vam mr5' }))
                                        .insert(new Element('span').update('[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__NO_IT_SERVICES"}]')));
                            } else {
                                for (i in json.data) {
                                    if (json.data.hasOwnProperty(i) && !isNaN(parseInt(i))) {
                                        $ul.insert(new Element('li', { className: 'service-selection', 'data-object': i })
                                            .update(new Element('img', { src: window.dir_images + 'axialis/basic/link.svg', className: 'mr5' }))
                                            .insert(new Element('span').update(json.data[i])));
                                    }
                                }

                                $itserviceListContainer.update($ul);

                                if (json.data.hasOwnProperty('limit')) {
                                    $itserviceListContainer.insert({
                                        top:
                                            new Element('div', {className: 'm5 p5 box-blue'})
                                                .update(new Element('img', { src: window.dir_images + 'axialis/basic/button-info.svg', className: 'vam mr5' }))
                                                .insert(new Element('span').update(json.data.limit))
                                    });
                                }
                            }
                        } else {
                            idoit.Notify.error(json.message);
                        }
                    }
                });
            });

            $itserviceListContainer.on('click', 'li[data-object]', function (ev) {
                var $el = ev.findElement('li');

                $('C_VISUALIZATION_OBJ_SELECTION__VIEW')
                    .setValue('[{isys type="lang" ident="LC__OBJTYPE__IT_SERVICE"}] >> ' + ($el.down('span').textContent || $el.down('span').innerText));
                $('C_VISUALIZATION_OBJ_SELECTION__HIDDEN').setValue($el.readAttribute('data-object'));

                popup_close();

                idoit.callbackManager.triggerCallback('visualization-init-explorer');
            });

            // Clicks the first type "all" on startup.
            $itserviceTypeContainer.down('input').simulate('click');

            // Focus the search field.
            $search.focus();
        })();
    </script>
    <style>
        #visualization-popup {
            box-sizing: border-box;
            position: relative;
            height: 100%;
        }

        #visualization-popup li {
            padding: 8px;
            margin-bottom: 4px;
        }

        #visualization-popup li.active {
            background-color: #e4e4e4;
        }

        #visualization-popup li:hover {
            background-color: #eee;
        }

        #visualization-popup li label {
            display: block;
            width: 100%;
            cursor: pointer;
            display: flex;
            align-items: center;
        }

        #visualization-popup li.service-selection {
            display: block;
            cursor: pointer;
            display: flex;
            align-items: center;
        }

        #visualization-popup li.service-selection:hover {
            background-color: #eee;
        }

        #visualization-popup label {
            display: block;
        }

        #C_VISUALIZATION_ITS_SEARCH {
            height: 21px;
            margin-top: -3px;
        }

        #C_VISUALIZATION_ITS_CONTAINER {
            max-height: 92%;
            overflow-y: auto;
        }

        #C_VISUALIZATION_ITS_CONTAINER li span {
            width: 540px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            float: left;
        }

        #C_VISUALIZATION_ITS_TYPES span {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 200px;
            display: inline-block;
        }
    </style>
[{/isys_group}]
