<?php

namespace idoit\Component\Settings;

/**
 * i-doit Setting component
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

abstract class Settings
{
    /**
     * @param string $key
     * @param string $default
     *
     * @return mixed
     */
    abstract public function get($key = null, $default = ''): mixed;

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return mixed
     */
    abstract public function set($key, $value): mixed;

    /**
     * @param array $setting
     *
     * @return void
     */
    abstract public function extend($setting): void;

    /**
     * @param string $key
     *
     * @return void
     */
    abstract public function remove($key): void;

    /**
     * @return void
     */
    abstract public function save(): void;
}