<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Condition;

/**
 * Inverse the result of inner condition
 *
 * @package idoit\Component\Table\Filter\Condition
 */
class NotCondition implements ConditionInterface
{
    /**
     * @var ConditionInterface
     */
    private $condition;

    /**
     * NotCondition constructor.
     *
     * @param ConditionInterface $condition inner condition
     */
    public function __construct(ConditionInterface $condition)
    {
        $this->condition = $condition;
    }

    /**
     * @param        $name
     * @param        $value
     *
     * @return bool
     */
    public function check($name, $value): bool
    {
        return !$this->condition->check($name, $value);
    }
}
