<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ClusterInput
 * A cluster object. * @property null|bool $allMembersFound = null A flag whether all cluster members have been found.
 * @property null|iterable|DeviceInputInputType[] $associatedVirtualMachines = null The associated cluster member virtual machines.
Note, that this is not the list of VMs running in this cluster.
It is more a configuration item in some virtualization environments (e.g. XenServer). You can associate a VM with a cluster
and then the cluster decides on which physical host of the cluster the VM gets started.
 * @property null|iterable|DeviceInputInputType[] $clusterMembers = null The cluster member devices
 * @property null|iterable|KubernetesDaemonSetInputInputType[] $kubernetesDaemonSets = null The Kubernetes daemon sets that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|iterable|KubernetesDeploymentInputInputType[] $kubernetesDeployments = null The Kubernetes deployments that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|iterable|KubernetesNamespaceInputInputType[] $kubernetesNamespaces = null The Kubernetes namespaces that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|iterable|DeviceInputInputType[] $kubernetesPods = null The Kubernetes pods that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|iterable|KubernetesReplicaSetInputInputType[] $kubernetesReplicaSets = null The Kubernetes replica sets that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|iterable|DeviceInputInputType[] $kubernetesServices = null The Kubernetes services that belong to this cluster when the cluster is a Kubernetes cluster
 * @property null|string $name = null The cluster's name.
 * @property null|ClusterTypeEnum $type = null The cluster type
 * @property null|string $uniqueId = null The cluster's unique id.
 * @property null|VirtualDatacenterInputInputType $virtualDatacenter = null The virtual datacenter that a cluster belongs to.
 */
final class ClusterInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'associatedVirtualMachines') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'clusterMembers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesDaemonSets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesDaemonSetInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesDeployments') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesDeploymentInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesNamespaces') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesNamespaceInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesPods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesReplicaSets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new KubernetesReplicaSetInputInputType($v)); })($value);
        }

        if ($name === 'kubernetesServices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'type') {
            return new ClusterTypeEnum($value);
        }

        if ($name === 'virtualDatacenter') {
            return new VirtualDatacenterInputInputType($value);
        }

        return $value;
    }
}