<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CustomAttributeInput
 * A custom attribute definition * @property null|AttributeTypeEnum $attributeType = null The custom attribute type
 * @property null|bool $builtIn = null A flag whether this is a customer defined or built-in custom attribute
 * @property null|iterable|CustomAttributeInputInputType[] $children = null The direct child attributes (not the whole subtree)
 * @property null|string $description = null The custom attribute description
 * @property null|iterable|DeviceInputInputType[] $devices = null The list of devices having this custom attribute.
 * @property null|iterable|CustomAttributeEnumInputInputType[] $enumValues = null The list of enum values for this custom attribute.
 * @property null|int $keepHistoryForHours = null Keep the history for this attribute for <n> hours
 * @property null|string $name = null The custom attribute name
 * @property null|int $orderNumber = null The order number within the parent folder
 * @property null|string $path = null The full path of the attribute within the hierarchy
 */
final class CustomAttributeInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'attributeType') {
            return new AttributeTypeEnum($value);
        }

        if ($name === 'children') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new CustomAttributeInputInputType($v)); })($value);
        }

        if ($name === 'devices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'enumValues') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new CustomAttributeEnumInputInputType($v)); })($value);
        }

        return $value;
    }
}